<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <?php
        // Ana sayfa mı kontrol et
        $isHome = url()->current() === url('/');
    ?>

    <!-- Title -->
    <title>
        <?php if($isHome): ?>
<?php echo e($settings->site_name); ?> - Anasayfa
        <?php else: ?>
            <?php echo e($kategori->name ?? $settings->site_name); ?> - <?php echo e($settings->site_name); ?>

        <?php endif; ?>
    </title>

    <!-- Description -->
    <meta name="description" content="<?php echo e($isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description)); ?>">

    <!-- Keywords -->
    <meta name="keywords" content="<?php echo e($isHome ? '' : 'QR Menü, Dijital Menü, Restoran Menü, ' . ($kategori->name ?? '')); ?>">

    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo e($isHome ? $settings->site_name : ($kategori->name ?? $settings->site_name)); ?>">
    <meta property="og:description" content="<?php echo e($isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description)); ?>">
    <meta property="og:image" content="<?php echo e(asset($kategori->image ?? 'storage/assets/site_logo.png')); ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($isHome ? $settings->site_name : ($kategori->name ?? $settings->site_name)); ?>">
    <meta name="twitter:description" content="<?php echo e($isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description)); ?>">
    <meta name="twitter:image" content="<?php echo e(asset($kategori->image ?? 'storage/assets/site_logo.png')); ?>">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/assets/site_favicon.ico')); ?>">
    
    <?php echo $__env->make('includes.css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
<?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldPushContent('content'); ?>

<?php echo $__env->yieldPushContent('js'); ?>
<?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"tr","native_language_names":false,"detect_browser_language":true,"languages":["en","fr","de","it","es","tr","ar","ru","ka","fa","el","hy","id"],"wrapper_selector":".gtranslate_wrapper","switcher_horizontal_position":"left"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\qr-menu\resources\views/layouts/qr-layout.blade.php ENDPATH**/ ?>