<?php $__env->startPush('styles'); ?>
    
<?php $__env->stopPush(); ?>

<?php
    $isHome = url()->current() === url('/');
?>

<?php $__env->startPush('content'); ?>
<div class="app">

    <!-- 1) Öne Çıkan Yemekler / Vitrin -->
    <?php if($vitrins->count() > 0): ?>
    <section class="recommendations animate-in" aria-label="Öne çıkan yemekler">
        <h2>Bunları Beğenebilirsiniz</h2>
        <div class="rec-list">
            <?php $__currentLoopData = $vitrins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vitrin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($vitrin->status && $vitrin->yemek): ?>
                <article class="rec-item clickable-item"
                    data-name="<?php echo e($vitrin->yemek->name); ?>"
                    data-img="<?php echo e($vitrin->yemek->image ? asset('storage/' . $vitrin->yemek->image) : asset('assets/images/resimYok.jpg')); ?>"
                    data-desc="<?php echo e($vitrin->yemek->description); ?>"
                    data-button="<?php echo e(number_format($vitrin->yemek->price, 2, ',', '.')); ?>₺">
                    <div class="rec-thumb">
                        <img src="<?php echo e($vitrin->yemek->image ? asset('storage/' . $vitrin->yemek->image) : asset('assets/images/resimYok.jpg')); ?>" 
                             alt="<?php echo e($vitrin->yemek->name); ?> görseli" />
                    </div>
                    <span><?php echo e($vitrin->yemek->name); ?></span>
                    <p><?php echo e(number_format($vitrin->yemek->price, 2, ',', '.')); ?>₺</p>
                </article>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </section>
    <hr class="animate-in delay-1">
    <?php endif; ?>

    <!-- 2) Kategoriler -->
    <section class="quick-cats animate-in delay-1" aria-label="Yemek kategorileri">
        <?php $__currentLoopData = $kategoriler; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kategori): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route('kategori.show', $kategori->slug)); ?>" title="<?php echo e($kategori->name); ?>">
            <div class="qc-item" 
                 style="background-image: url('<?php echo e($kategori->image ? asset('storage/' . $kategori->image) : asset('assets/images/resimYok.jpg')); ?>');">
                <h3><?php echo e($kategori->name); ?></h3>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </section>

    <!-- 3) Haftanın Menüsü -->
   <?php if($weeklyMenu && $weeklyMenu->yemek && $weeklyMenu->yemek->is_active): ?>
    <hr class="animate-in delay-1">
    <section class="big-card-section animate-in delay-3" aria-label="Haftanın Menüsü">
        <article class="qc-item big-card-section clickable-item"
            data-name="<?php echo e($weeklyMenu->yemek->name); ?>"
            data-img="<?php echo e($weeklyMenu->yemek->image ? asset('storage/' . $weeklyMenu->yemek->image) : asset('assets/images/resimYok.jpg')); ?>"
            data-desc="<?php echo e($weeklyMenu->yemek->description ?? ''); ?>"
            data-button="<?php echo e(number_format($weeklyMenu->yemek->price, 2, ',', '.')); ?>₺"
            style="justify-content: flex-start; padding: 20px; align-items: baseline; height: 210px; background-image: url('<?php echo e($weeklyMenu->yemek->image ? asset('storage/' . $weeklyMenu->yemek->image) : 'https://via.placeholder.com/724x409'); ?>');">
            <h4>Haftanın Menüsü</h4>
            <h2><?php echo e($weeklyMenu->yemek->name); ?></h2>
            <p class="price" id="yazi"><?php echo e(number_format($weeklyMenu->yemek->price, 2, ',', '.')); ?>₺</p>
        </article>
    </section>

    <script>
        const yazi = document.getElementById("yazi");
        let fontSize = 14;
        let direction = 1;
        const minSize = 14;
        const maxSize = 24;
        const speed = 0.12;

        function animateFont() {
          fontSize += direction * speed;
          if (fontSize >= maxSize) direction = -1;
          if (fontSize <= minSize) direction = 1;
          yazi.style.fontSize = fontSize + "px";
          requestAnimationFrame(animateFont);
        }
        animateFont();
    </script>
<?php endif; ?>


    <hr class="animate-in delay-1">

   <section class="restaurant-photo animate-in delay-5" aria-label="Restoran fotoğrafı">
    <div class="restaurant-card">
        <div class="restaurant-image"
            style="background-image: url('<?php echo e(!empty($moreConfigs['restoran_image']) ? $moreConfigs['restoran_image'] : asset('assets/images/resimYok.jpg')); ?>');"
            aria-label="Restoran fotoğrafı">
            
            <!-- Alt degradeli bilgi kutusu -->
            <div class="restaurant-info-gradient">
                <h3><?php echo e($settings->site_name ?? 'Ayarlanmadı'); ?></h3>
                <p><?php echo e($settings->site_description ?? 'Ayarlanmadı'); ?></p>
            </div>
        </div>
    </div>
</section>



    <?php if(session('success')): ?>
        <div role="alert" style="color: green;"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <!-- 5) Dilek/Öneri/Şikayet -->
    <section class="feedback animate-in delay-6" aria-label="Dilek, öneri veya şikayet">
        <h2>Dilek, Öneri veya Şikayet</h2>
        <form action="<?php echo e(route('index.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <textarea name="subject" placeholder="Mesajınızı yazın…" aria-label="Mesaj"></textarea>
            <button type="submit" id="sendFeedback">Gönder</button>
        </form>
    </section>

    <footer class="footer animate-in delay-6">
        <div class="footer-bottom reveal" style="transition-delay:0.6s;">
            <span id="current-year"></span>DESIGNED BY A
        </div>
    </footer>
</div>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.qr-layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\qr-menu\resources\views/index.blade.php ENDPATH**/ ?>