<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\KategoriController;
use App\Models\Kategori;
use App\Http\Controllers\IndexController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [IndexController::class, 'index'])->name('index');
Route::post('/', [IndexController::class, 'store'])->name('index.store');
Route::get('/kategori/{slug}', [KategoriController::class, 'show'])->name('kategori.show');

Route::get('/kategori/{id}', function ($id) {
    $kategori = \App\Models\Kategori::findOrFail($id);
    return redirect()->route('category', ['slug' => $kategori->slug]);
});


Route::get('/storage-link-00', function () {
    try {
        Artisan::call('storage:link');
        return 'Link başarıyla oluşturuldu.';
    } catch (\Exception $e) {
        return 'Hataw: ' . $e->getMessage();
    }
});


Route::get('/clear-cache-00', function() {
    Artisan::call('optimize:clear');
    return "Cache temizlendi";
});