<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    @php
        // Ana sayfa mı kontrol et
        $isHome = url()->current() === url('/');
    @endphp

    <!-- Title -->
    <title>
        @if($isHome)
{{ $settings->site_name }} - Anasayfa
        @else
            {{ $kategori->name ?? $settings->site_name }} - {{ $settings->site_name }}
        @endif
    </title>

    <!-- Description -->
    <meta name="description" content="{{ $isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description) }}">

    <!-- Keywords -->
    <meta name="keywords" content="{{ $isHome ? '' : 'QR Menü, Dijital Menü, Restoran Menü, ' . ($kategori->name ?? '') }}">

    <!-- Open Graph -->
    <meta property="og:title" content="{{ $isHome ? $settings->site_name : ($kategori->name ?? $settings->site_name) }}">
    <meta property="og:description" content="{{ $isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description) }}">
    <meta property="og:image" content="{{ asset($kategori->image ?? 'storage/assets/site_logo.png') }}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="{{ $isHome ? $settings->site_name : ($kategori->name ?? $settings->site_name) }}">
    <meta name="twitter:description" content="{{ $isHome ? $settings->site_description : ($kategori->description ?? $settings->site_description) }}">
    <meta name="twitter:image" content="{{ asset($kategori->image ?? 'storage/assets/site_logo.png') }}">

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ asset('storage/assets/site_favicon.ico') }}">
    
    @include('includes.css')
    @stack('styles')
</head>
<body>
@include('includes.header')

@stack('content')

@stack('js')
@include('includes.footer')
<div class="gtranslate_wrapper"></div>
<script>window.gtranslateSettings = {"default_language":"tr","native_language_names":false,"detect_browser_language":true,"languages":["en","fr","de","it","es","tr","ar","ru","ka","fa","el","hy","id"],"wrapper_selector":".gtranslate_wrapper","switcher_horizontal_position":"left"}</script>
<script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
</body>
</html>
