@extends('layouts.qr-layout')

@push('styles')
    
@endpush

@php
    $isHome = url()->current() === url('/');
@endphp

@push('content')
<div class="app">

    <!-- 1) Öne Çıkan Yemekler / Vitrin -->
    @if ($vitrins->count() > 0)
    <section class="recommendations animate-in" aria-label="Öne çıkan yemekler">
        <h2>Bunları Beğenebilirsiniz</h2>
        <div class="rec-list">
            @foreach ($vitrins as $vitrin)
                @if ($vitrin->status && $vitrin->yemek)
                <article class="rec-item clickable-item"
                    data-name="{{ $vitrin->yemek->name }}"
                    data-img="{{ $vitrin->yemek->image ? asset('storage/' . $vitrin->yemek->image) : asset('assets/images/resimYok.jpg') }}"
                    data-desc="{{ $vitrin->yemek->description }}"
                    data-button="{{ number_format($vitrin->yemek->price, 2, ',', '.') }}₺">
                    <div class="rec-thumb">
                        <img src="{{ $vitrin->yemek->image ? asset('storage/' . $vitrin->yemek->image) : asset('assets/images/resimYok.jpg') }}" 
                             alt="{{ $vitrin->yemek->name }} görseli" />
                    </div>
                    <span>{{ $vitrin->yemek->name }}</span>
                    <p>{{ number_format($vitrin->yemek->price, 2, ',', '.') }}₺</p>
                </article>
                @endif
            @endforeach
        </div>
    </section>
    <hr class="animate-in delay-1">
    @endif

    <!-- 2) Kategoriler -->
    <section class="quick-cats animate-in delay-1" aria-label="Yemek kategorileri">
        @foreach($kategoriler as $kategori)
        <a href="{{ route('kategori.show', $kategori->slug) }}" title="{{ $kategori->name }}">
            <div class="qc-item" 
                 style="background-image: url('{{ $kategori->image ? asset('storage/' . $kategori->image) : asset('assets/images/resimYok.jpg') }}');">
                <h3>{{ $kategori->name }}</h3>
            </div>
        </a>
        @endforeach
    </section>

    <!-- 3) Haftanın Menüsü -->
   @if($weeklyMenu && $weeklyMenu->yemek && $weeklyMenu->yemek->is_active)
    <hr class="animate-in delay-1">
    <section class="big-card-section animate-in delay-3" aria-label="Haftanın Menüsü">
        <article class="qc-item big-card-section clickable-item"
            data-name="{{ $weeklyMenu->yemek->name }}"
            data-img="{{ $weeklyMenu->yemek->image ? asset('storage/' . $weeklyMenu->yemek->image) : asset('assets/images/resimYok.jpg') }}"
            data-desc="{{ $weeklyMenu->yemek->description ?? '' }}"
            data-button="{{ number_format($weeklyMenu->yemek->price, 2, ',', '.') }}₺"
            style="justify-content: flex-start; padding: 20px; align-items: baseline; height: 210px; background-image: url('{{ $weeklyMenu->yemek->image ? asset('storage/' . $weeklyMenu->yemek->image) : 'https://via.placeholder.com/724x409' }}');">
            <h4>Haftanın Menüsü</h4>
            <h2>{{ $weeklyMenu->yemek->name }}</h2>
            <p class="price" id="yazi">{{ number_format($weeklyMenu->yemek->price, 2, ',', '.') }}₺</p>
        </article>
    </section>

    <script>
        const yazi = document.getElementById("yazi");
        let fontSize = 14;
        let direction = 1;
        const minSize = 14;
        const maxSize = 24;
        const speed = 0.12;

        function animateFont() {
          fontSize += direction * speed;
          if (fontSize >= maxSize) direction = -1;
          if (fontSize <= minSize) direction = 1;
          yazi.style.fontSize = fontSize + "px";
          requestAnimationFrame(animateFont);
        }
        animateFont();
    </script>
@endif


    <hr class="animate-in delay-1">

   <section class="restaurant-photo animate-in delay-5" aria-label="Restoran fotoğrafı">
    <div class="restaurant-card">
        <div class="restaurant-image"
            style="background-image: url('{{ !empty($moreConfigs['restoran_image']) ? $moreConfigs['restoran_image'] : asset('assets/images/resimYok.jpg') }}');"
            aria-label="Restoran fotoğrafı">
            
            <!-- Alt degradeli bilgi kutusu -->
            <div class="restaurant-info-gradient">
                <h3>{{ $settings->site_name ?? 'Ayarlanmadı' }}</h3>
                <p>{{ $settings->site_description ?? 'Ayarlanmadı' }}</p>
            </div>
        </div>
    </div>
</section>



    @if(session('success'))
        <div role="alert" style="color: green;">{{ session('success') }}</div>
    @endif

    <!-- 5) Dilek/Öneri/Şikayet -->
    <section class="feedback animate-in delay-6" aria-label="Dilek, öneri veya şikayet">
        <h2>Dilek, Öneri veya Şikayet</h2>
        <form action="{{ route('index.store') }}" method="POST">
            @csrf
            <textarea name="subject" placeholder="Mesajınızı yazın…" aria-label="Mesaj"></textarea>
            <button type="submit" id="sendFeedback">Gönder</button>
        </form>
    </section>

    <footer class="footer animate-in delay-6">
        <div class="footer-bottom reveal" style="transition-delay:0.6s;">
            <span id="current-year"></span>DESIGNED BY A
        </div>
    </footer>
</div>
@endpush

@push('js')
    
@endpush
