<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Kategori;
use Illuminate\Support\Str;

class KategoriSlugSeeder extends Seeder
{
    public function run(): void
    {
        Kategori::all()->each(function($kategori){
            $kategori->slug = Str::slug($kategori->name);
            $kategori->save();
        });

        $this->command->info('Tüm kategorilerin slugları başarıyla oluşturuldu!');
    }
}
