<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('yemekler', function (Blueprint $table) {
           $table->id();
        $table->foreignId('kategori_id')->constrained()->onDelete('cascade');
        $table->string('name');
        $table->string('image')->nullable();
        $table->text('description')->nullable();
        $table->decimal('price', 8, 2);
        $table->boolean('is_active')->default(true);
        $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('yemekler');
    }
};
