<?php

use Joaopaulolndev\FilamentGeneralSettings\Enums\TypeFieldEnum;

return [
    'show_application_tab' => true,
    'show_logo_and_favicon' => true,
    'show_analytics_tab' => false,
    'show_seo_tab' => false,
    'show_email_tab' => false,
    'show_social_networks_tab' => false,
    'expiration_cache_config_time' => 60,
    'show_custom_tabs'=> true,
    'custom_tabs' => [
    'wifi_settings' => [
        'label' => 'Wifi Ayarları',
        'icon' => 'heroicon-o-wifi',
        'columns' => 1,
        'fields' => [
            'wifi_name' => [
                'type' => TypeFieldEnum::Text->value,
                'label' => 'Wifi Adı',
                'placeholder' => 'Wifi Adı',
                'required' => false,
                'rules' => 'string|max:255',
            ],
            'wifi_password' => [
                'type' => TypeFieldEnum::Text->value,
                'label' => 'Wifi Şifresi',
                'placeholder' => 'Wifi Şifresi',
                'required' => false,
                'rules' => 'string|max:255',
            ],
        ],
    ],
    'restoran_settings' => [
        'label' => 'Restoran Ayarları',
        'icon' => 'heroicon-o-building-storefront',
        'columns' => 1,
        'fields' => [
                       'restoran_image' => [
                'type' => TypeFieldEnum::Url->value,  // burası önemli
                'label' => 'Restoran Görseli',
                'required' => false,
                'placeholder' => 'Restoran Görseli URL',
                'rules' => 'nullable|string|max:255',  // max 1MB
            ],
                       'restoran_adres' => [
                'type' => TypeFieldEnum::Text->value,  // burası önemli
                'label' => 'Restoran Adresi',
                'required' => false,
                'placeholder' => 'Restoran Adresi',
                'rules' => 'nullable|string|max:255',  // max 1MB
            ],
        ],
    ],

    
],

];
