<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Kategori extends Model
{
    use HasFactory;

    protected $table = 'kategoris';  // tablo adı doğru ise bırak, değilse değiştir

    protected $fillable = [
        'name',
        'image',
        'is_active',
        'order',
    ];

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($kategori) {
            $kategori->slug = Str::slug($kategori->name);
        });

        static::updating(function ($kategori) {
            $kategori->slug = Str::slug($kategori->name);
        });
    }

    // Yemekler ile bire çok ilişki
    public function yemekler()
    {
        return $this->hasMany(Yemekler::class);
    }
}
