<?php

namespace App\Filament\Resources\WeeklyMenuResource\Pages;

use App\Filament\Resources\WeeklyMenuResource;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;
use Filament\Resources\Pages\EditRecord;

class EditWeeklyMenu extends EditRecord
{
    protected static string $resource = WeeklyMenuResource::class;

    protected function mutateFormDataBeforeSave(array $data): array
    {
        // Düzenleme demo modunda engellensin
        if (config('app.demo')) {
            Notification::make()
                ->title('Demo Mod')
                ->body('Düzenleme işlemi demo modunda devre dışıdır.')
                ->danger()
                ->send();

            throw new Halt();
        }

        return $data;
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
                ->before(function () {
                    // Silme demo modunda engellensin
                    if (config('app.demo')) {
                        Notification::make()
                            ->title('Demo Mod')
                            ->body('Silme işlemi demo modunda devre dışıdır.')
                            ->danger()
                            ->send();

                        throw new Halt();
                    }
                }),
        ];
    }
}
