<?php

namespace App\Filament\Resources\WeeklyMenuResource\Pages;

use App\Filament\Resources\WeeklyMenuResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;

class CreateWeeklyMenu extends CreateRecord
{
    protected static string $resource = WeeklyMenuResource::class;

    protected function beforeCreate(): void
    {
        if (config('app.demo', false)) {
            Notification::make()
                ->danger()
                ->title('Demo modunda bu işlem yapılamaz.')
                ->send();
            $this->halt(); // Kaydı durdurur
        }
    }
}
