<?php

namespace App\Filament\Resources;

use App\Filament\Resources\WeeklyMenuResource\Pages;
use App\Models\WeeklyMenu;
use Filament\Forms;
use Filament\Forms\Form;
use App\Models\Yemekler;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;

class WeeklyMenuResource extends Resource
{
    protected static ?string $model = WeeklyMenu::class;

    protected static ?string $navigationGroup = 'Ana Sayfa';
    protected static ?string $navigationLabel = 'Haftanın Menüsü';
    protected static ?string $pluralModelLabel = 'Haftanın Menüsü';
    protected static ?int $navigationSort = 3;
    protected static ?string $slug = 'haftanin-menusu';
    protected static ?string $navigationIcon = 'heroicon-o-calendar';

   public static function form(Form $form): Form
{
    return $form
        ->schema([
            Forms\Components\Select::make('yemek_id')
    ->label('Haftanın Yemeği')
    ->relationship('yemek', 'name', fn ($query) => $query->where('is_active', true))
    ->searchable()
    ->required(),

        ]);
}


    public static function table(Table $table): Table
    {
        return $table
            ->columns([
    Tables\Columns\ImageColumn::make('yemek.image')
        ->label('Resim')
        ->rounded()
        ->height(60)
        ->width(60),

    Tables\Columns\TextColumn::make('yemek.name')
        ->label('Yemek Adı')
        ->searchable(),

    Tables\Columns\TextColumn::make('yemek.price')
        ->label('Fiyat')
        ->money('try', true),

    Tables\Columns\IconColumn::make('yemek.is_active')
        ->label('Aktiflik')
        ->boolean()
        ->trueIcon('heroicon-o-check-circle')
        ->falseIcon('heroicon-o-x-circle')
        ->colors([
            'success' => fn ($state) => $state === true,
            'danger' => fn ($state) => $state === false,
        ]),
])

            ->filters([])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make()
                    ->label('Sil')
                    ->icon('heroicon-o-trash')
                    ->color('danger')
                    ->before(function () {
                        if (config('app.demo')) {
                            Notification::make()
                                ->title('Demo Mod')
                                ->body('Silme işlemi demo modunda devre dışıdır.')
                                ->danger()
                                ->send();

                            throw new Halt();
                        }
                    }),
            ])
            ->bulkActions([]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListWeeklyMenus::route('/'),
            'edit' => Pages\EditWeeklyMenu::route('/{record}/edit'),
        ];
    }
}
