<?php

namespace App\Filament\Resources\VitrinResource\Pages;

use App\Filament\Resources\VitrinResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Support\Exceptions\Halt;

class EditVitrin extends EditRecord
{
    protected static string $resource = VitrinResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
                ->before(function () {
                    if (config('app.demo', false)) {
                        Notification::make()
                            ->danger()
                            ->title('Demo modunda silme yapılamaz.')
                            ->send();

                        throw new Halt();
                    }
                }),
        ];
    }

    protected function beforeSave(): void
    {
        if (config('app.demo', false)) {
            Notification::make()
                ->danger()
                ->title('Demo modunda düzenleme yapılamaz.')
                ->send();

            throw new Halt(); // Düzenlemeyi durdurur
        }
    }
}
