<?php

namespace App\Filament\Resources\UserResource\Pages;

use App\Filament\Resources\UserResource;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;

class CreateUser extends CreateRecord
{
    protected static string $resource = UserResource::class;

    protected function beforeCreate(): void
    {
        if (config('app.demo', false)) {
            Notification::make()
                ->danger()
                ->title('Demo modunda bu işlem yapılamaz.')
                ->send();
            $this->halt(); // Kaydı durdurur
        }
    }

}
