<?php

namespace App\Filament\Resources\KategoriResource\Pages;

use App\Filament\Resources\KategoriResource;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Actions;

class EditKategori extends EditRecord
{
    protected static string $resource = KategoriResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make()
                ->before(function () {
                    if (config('app.demo', false)) {
                        Notification::make()
                            ->danger()
                            ->title('Demo modunda bu işlem yapılamaz.')
                            ->send();

                        $this->halt(); // Silmeyi durdurur
                    }
                }),
        ];
    }

    protected function beforeSave(): void
    {
        if (config('app.demo', false)) {
            Notification::make()
                ->danger()
                ->title('Demo modunda bu işlem yapılamaz.')
                ->send();

            $this->halt(); // Kaydı durdurur
        }
    }
}
