export interface SupportTicket {
  id: string
  ticketNumber: string
  userId: string
  user: {
    id: string
    username: string
    email: string
    firstName: string
    lastName: string
  }
  subject: string
  description: string
  category: SupportCategory
  priority: SupportPriority
  status: SupportStatus
  attachments: SupportAttachment[]
  messages: SupportMessage[]
  assignedTo?: {
    id: string
    name: string
    email: string
    role: string
  }
  createdAt: string
  updatedAt: string
  resolvedAt?: string
  closedAt?: string
  tags: string[]
  rating?: {
    score: number // 1-5
    comment?: string
    ratedAt: string
  }
}

export type SupportCategory = 
  | 'account'
  | 'payment'
  | 'task'
  | 'technical'
  | 'general'
  | 'bug_report'
  | 'feature_request'
  | 'other'

export type SupportPriority = 'low' | 'medium' | 'high' | 'urgent'

export type SupportStatus = 
  | 'open'
  | 'in_progress'
  | 'waiting_for_user'
  | 'resolved'
  | 'closed'
  | 'cancelled'

export interface SupportMessage {
  id: string
  ticketId: string
  authorId: string
  author: {
    id: string
    name: string
    email: string
    role: 'user' | 'support' | 'admin'
    avatar?: string
  }
  content: string
  attachments: SupportAttachment[]
  isInternal: boolean // sadece support ekibi görebilir
  createdAt: string
  updatedAt: string
  isRead: boolean
}

export interface SupportAttachment {
  id: string
  filename: string
  originalName: string
  mimeType: string
  size: number
  url: string
  uploadedAt: string
  uploadedBy: string
}

export interface CreateSupportTicket {
  subject: string
  description: string
  category: SupportCategory
  priority?: SupportPriority
  attachments?: File[]
  tags?: string[]
}

export interface UpdateSupportTicket {
  subject?: string
  description?: string
  category?: SupportCategory
  priority?: SupportPriority
  status?: SupportStatus
  tags?: string[]
}

export interface CreateSupportMessage {
  ticketId: string
  content: string
  attachments?: File[]
  isInternal?: boolean
}

export interface SupportFilter {
  status?: SupportStatus[]
  category?: SupportCategory[]
  priority?: SupportPriority[]
  assignedTo?: string[]
  dateRange?: {
    start: string
    end: string
  }
  search?: string
  sortBy?: 'created_at' | 'updated_at' | 'priority' | 'status'
  sortOrder?: 'asc' | 'desc'
}

export interface SupportStats {
  totalTickets: number
  openTickets: number
  resolvedTickets: number
  averageResponseTime: number // saat cinsinden
  averageResolutionTime: number // saat cinsinden
  satisfactionRating: number // 1-5 arası ortalama
  ticketsByCategory: Record<SupportCategory, number>
  ticketsByPriority: Record<SupportPriority, number>
  ticketsByStatus: Record<SupportStatus, number>
  recentTickets: SupportTicket[]
}

export interface FAQ {
  id: string
  question: string
  answer: string
  category: FAQCategory
  tags: string[]
  isPublished: boolean
  order: number
  views: number
  helpful: number
  notHelpful: number
  createdAt: string
  updatedAt: string
}

export interface FAQCategory {
  id: string
  name: string
  slug: string
  description?: string
  icon?: string
  order: number
  faqCount: number
}

export interface ContactForm {
  name: string
  email: string
  phone?: string
  subject: string
  message: string
  category: 'general' | 'business' | 'technical' | 'partnership'
  attachments?: File[]
}