// 🎨 Renk Paleti - ProjectFlow.md'den
export const COLORS = {
  background: '#141023',
  primary: '#8570FF',
  baseColor1: '#171325',
  baseColor2: '#1B172A',
  baseColor3: '#211D2F',
} as const

// 📱 Navigasyon Menü Öğeleri
export const MENU_ITEMS = [
  { id: 'home', label: 'Ana Sayfa', href: '/home', icon: 'home' },
  { id: 'macro-tasks', label: 'Makro Görevler', href: '/macro-tasks', icon: 'tasks' },
  { id: 'micro-tasks', label: 'Mikro Görevler', href: '/micro-tasks', icon: 'list' },
  { id: 'listen-earn', label: 'Dinle Kazan', href: '/listen-earn', icon: 'headphones' },
  { id: 'my-tasks', label: 'Görevlerim', href: '/my-tasks', icon: 'user-tasks' },
  { id: 'wallet', label: 'Bakiye Çek', href: '/wallet', icon: 'wallet' },
  { id: 'leaderboard', label: 'Liderlik Sıralaması', href: '/leaderboard', icon: 'trophy' },
  { id: 'references', label: 'Referanslar', href: '/references', icon: 'users' },
  { id: 'reference-rewards', label: 'Referans Ödülleri', href: '/reference-rewards', icon: 'gift' },
] as const

export const MENU_ITEMS_BOTTOM = [
  { id: 'support', label: 'Destek Taleplerim', href: '/support', icon: 'help' },
  { id: 'blog', label: 'Blog', href: '/blog', icon: 'blog', isPublic: true },
  { id: 'faq', label: 'Sıkça Sorulan Sorular', href: '/faq', icon: 'question', isPublic: true },
  { id: 'settings', label: 'Ayarlar', href: '/settings', icon: 'settings' },
] as const

// 🌐 Genel Sabitler
export const APP_CONFIG = {
  name: 'Kiqro',
  domain: 'www.kiqro.com',
  supportEmail: 'destek@kiqro.com',
  phone: '+90 (555) 123 45 67',
  address: 'İstanbul, Türkiye',
} as const

// 💰 Para Birimi
export const CURRENCY = {
  symbol: '₺',
  code: 'TL',
  name: 'Türk Lirası',
} as const

// 📊 Sayfalama
export const PAGINATION = {
  defaultPageSize: 12,
  maxPageSize: 50,
} as const

// 🔐 Validasyon
export const VALIDATION = {
  minPasswordLength: 8,
  maxPasswordLength: 128,
  minUsernameLength: 3,
  maxUsernameLength: 20,
  maxMessageLength: 1000,
} as const

// 📱 Responsive Breakpoints (Tailwind uyumlu)
export const BREAKPOINTS = {
  sm: '640px',
  md: '768px',
  lg: '1024px',
  xl: '1280px',
  '2xl': '1536px',
} as const

// 🎯 Task Türleri
export const TASK_TYPES = {
  MICRO: 'micro',
  MACRO: 'macro',
  SURVEY: 'survey',
  LISTEN: 'listen',
} as const

// 📈 Task Durumları
export const TASK_STATUS = {
  PENDING: 'pending',
  IN_PROGRESS: 'in_progress',
  COMPLETED: 'completed',
  REJECTED: 'rejected',
  EXPIRED: 'expired',
} as const