/**
 * Support/Ticket Data
 * Separation of Concerns: Data layer
 */

export interface ChatMessage {
  id: string
  sender: string
  avatar: string
  message: string
  time: string
  isUser: boolean
}

export interface SupportTicket {
  id: string
  title: string
  status: 'İnceleniyor' | 'Cevaplandı' | 'Çözümlendi'
  messages: ChatMessage[]
}

// Support ticket verileri
export const supportTickets: Record<string, SupportTicket> = {
  '1': {
    id: '1',
    title: 'Görevim ne zaman onaylanacak',
    status: 'İnceleniyor',
    messages: [
      {
        id: '1',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Merhaba! Göreviniz ile ilgili talebinizi aldık. Göreviniz inceleme sürecindedir.',
        time: '10:15',
        isUser: false
      },
      {
        id: '2',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Teşekkürler, ne kadar sürer tahminen?',
        time: '10:18',
        isUser: true
      },
      {
        id: '3',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Görev onayları genellikle 24-48 saat içerisinde tamamlanmaktadır. En kısa sürede size dönüş yapacağız.',
        time: '10:25',
        isUser: false
      }
    ]
  },
  '2': {
    id: '2',
    title: 'Param gelmedi',
    status: 'Cevaplandı',
    messages: [
      {
        id: '1',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Merhaba! Ödeme ile ilgili talebinizi inceliyoruz.',
        time: '09:20',
        isUser: false
      },
      {
        id: '2',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: '3 gün önce görev tamamladım ama ödeme hesabıma yansımadı.',
        time: '09:25',
        isUser: true
      },
      {
        id: '3',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Kontrol ettik, ödemeniz sistem tarafından işleme alınmış. Hesabınıza 1-2 saat içerisinde yansıyacaktır.',
        time: '09:40',
        isUser: false
      },
      {
        id: '4',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Harika, çok teşekkürler! 🙏',
        time: '09:42',
        isUser: true
      }
    ]
  },
  '3': {
    id: '3',
    title: 'Bakım ne zaman gözükecek',
    status: 'Çözümlendi',
    messages: [
      {
        id: '1',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Site bakımda ne zaman açılacak?',
        time: '14:10',
        isUser: true
      },
      {
        id: '2',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Bakım işlemlerimiz tamamlandı. Artık siteyi normal şekilde kullanabilirsiniz.',
        time: '14:30',
        isUser: false
      },
      {
        id: '3',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Süper, teşekkürler! ✨',
        time: '14:32',
        isUser: true
      }
    ]
  },
  '4': {
    id: '4',
    title: 'Referans ödülüm eksik',
    status: 'İnceleniyor',
    messages: [
      {
        id: '1',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Referans sisteminden 5 kişi kaydoldu ama sadece 3 kişinin ödülü geldi.',
        time: '11:05',
        isUser: true
      },
      {
        id: '2',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Konuyu inceliyoruz. Referans kayıtlarınızı kontrol edip size geri dönüş yapacağız.',
        time: '11:20',
        isUser: false
      }
    ]
  },
  '5': {
    id: '5',
    title: 'Çekim işlemi yapamıyorum',
    status: 'Cevaplandı',
    messages: [
      {
        id: '1',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Papara ile çekim yapmaya çalışıyorum ama hata veriyor.',
        time: '16:30',
        isUser: true
      },
      {
        id: '2',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Minimum çekim tutarı 50 TL\'dir. Bakiyenizi kontrol eder misiniz?',
        time: '16:35',
        isUser: false
      },
      {
        id: '3',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Aa evet, bakiyem 45 TL\'ymiş. Anladım, teşekkürler!',
        time: '16:37',
        isUser: true
      }
    ]
  },
  '6': {
    id: '6',
    title: 'Hesabım neden kilitlendi?',
    status: 'Çözümlendi',
    messages: [
      {
        id: '1',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Hesabıma giriş yapamıyorum, "hesap kilitli" diyor.',
        time: '08:15',
        isUser: true
      },
      {
        id: '2',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Güvenlik nedeniyle hesabınız geçici olarak kilitlenmiş. Kimlik doğrulaması yapmanız gerekiyor.',
        time: '08:25',
        isUser: false
      },
      {
        id: '3',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Nasıl yapacağım?',
        time: '08:27',
        isUser: true
      },
      {
        id: '4',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'E-posta adresinize doğrulama linki gönderdik. Linke tıklayarak hesabınızı aktifleştirebilirsiniz.',
        time: '08:30',
        isUser: false
      },
      {
        id: '5',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Tamamdır, hallettim. Sağolun! 👍',
        time: '08:35',
        isUser: true
      }
    ]
  },
  '7': {
    id: '7',
    title: 'Instagram görevi tamamlanamıyor',
    status: 'İnceleniyor',
    messages: [
      {
        id: '1',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Instagram takip görevini yaptım ama onaylanmadı.',
        time: '13:45',
        isUser: true
      },
      {
        id: '2',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Instagram kullanıcı adınızı doğru girdiğinizden emin misiniz? Tekrar kontrol eder misiniz?',
        time: '13:50',
        isUser: false
      },
      {
        id: '3',
        sender: 'Arda Kılıç',
        avatar: '/assets/images/pp1.png',
        message: 'Evet doğru girdim. Ekran görüntüsü de yükledim.',
        time: '13:52',
        isUser: true
      },
      {
        id: '4',
        sender: 'Destek Ekibi',
        avatar: '/assets/images/pp1.png',
        message: 'Anlıyorum. Görevinizi manuel olarak kontrol edip 24 saat içerisinde onaylayacağız.',
        time: '14:00',
        isUser: false
      }
    ]
  }
}

// Helper function - Ticket bilgisini al
export const getTicketById = (id: string): SupportTicket => {
  return supportTickets[id] || supportTickets['1']
}

// Helper function - Tüm ticketları listele
export const getAllTickets = (): SupportTicket[] => {
  return Object.values(supportTickets)
}
