/**
 * Offers Data
 * Separation of Concerns: Data layer
 */

export interface TaskRequirement {
  title: string;
  description: string;
}

export interface TaskReward {
  amount: string;
  label: string;
  completed: boolean;
}

export interface OfferCardData {
  id: string;
  title: string;
  subtitle: string;
  amount: string;
  image: string;
  imageAlt: string;
  rating?: number;
  rewards?: TaskReward[];
  taskFlexibility?: TaskRequirement;
  newMembers?: TaskRequirement;
  description?: TaskRequirement;
  category?: 'green' | 'pink' | 'yellow'; // Kategori rengi
}

export const bankingOffers: OfferCardData[] = [
  {
    id: '1',
    title: 'Denizbank',
    subtitle: 'Torox Premium',
    amount: '435.23₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Denizbank',
    rating: 4,
    rewards: [
      { amount: '0,15₺', label: 'Complete Event 1', completed: false },
      { amount: '0,15₺', label: 'Complete Event 1', completed: false },
      { amount: '0,15₺', label: 'Complete Event 1', completed: true },
      { amount: '0,15₺', label: 'Complete Event 1', completed: true },
      { amount: '0,15₺', label: 'Complete Event 1', completed: true },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Bu görevi doğru bir şekilde yapmanız gerekmektedir...'
    }
  },
  {
    id: '2',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA',
    rating: 5,
    rewards: [
      { amount: '0,20₺', label: 'Complete Event 1', completed: true },
      { amount: '0,20₺', label: 'Complete Event 2', completed: true },
      { amount: '0,20₺', label: 'Complete Event 3', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Bu görevi doğru bir şekilde yapmanız gerekmektedir...'
    }
  },
  {
    id: '3',
    title: 'Yapı Kredi',
    subtitle: 'World Kart',
    amount: '850.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Yapı Kredi',
    rating: 4,
    rewards: [
      { amount: '0,50₺', label: 'Complete Event 1', completed: true },
      { amount: '0,50₺', label: 'Complete Event 2', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'World Card başvurusu yapın ve onaylandıktan sonra ödülünüzü kazanın.'
    }
  },
  {
    id: '4',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA'
  },
  {
    id: '4',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA'
  },
  {
    id: '4',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA'
  },
  {
    id: '4',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA'
  }
]

export const techOffers: OfferCardData[] = [
  {
    id: '1',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'green',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '2',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'green',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '3',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'YouTube Premium',
    rating: 5,
    category: 'green',
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '4',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'pink',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '5',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'pink',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '6',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'YouTube Premium',
    rating: 5,
    category: 'pink',
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '7',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'yellow',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '8',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'yellow',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '3',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'YouTube Premium',
    category: 'yellow',
    rating: 5,
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  }
]

export const taskPartners: OfferCardData[] = [
  {
    id: "1",
    title: "Lootably",
    subtitle: "",
    amount: "",
    image: "/assets/images/görev_ortakları/1.png",
    imageAlt: "Lootably",
    rating: 5,
    rewards: [
      { amount: 'Değişken', label: 'Görev Tamamlama', completed: false },
    ],
    description: {
      title: 'Açıklama',
      description: 'Lootably partneri ile çeşitli görevleri tamamlayarak ödül kazanın.'
    }
  },
  {
    id: "2",
    title: "Torox",
    subtitle: "",
    amount: "",
    image: "/assets/images/görev_ortakları/2.png",
    imageAlt: "Torox",
    rating: 5,
    rewards: [
      { amount: 'Değişken', label: 'Görev Tamamlama', completed: false },
    ],
    description: {
      title: 'Açıklama',
      description: 'Torox partneri ile çeşitli görevleri tamamlayarak ödül kazanın.'
    }
  },
  {
    id: "3",
    title: "RevU",
    subtitle: "",
    amount: "",
    image: "/assets/images/görev_ortakları/3.png",
    imageAlt: "RevU",
    rating: 5,
    rewards: [
      { amount: 'Değişken', label: 'Görev Tamamlama', completed: false },
    ],
    description: {
      title: 'Açıklama',
      description: 'RevU partneri ile çeşitli görevleri tamamlayarak ödül kazanın.'
    }
  },
  {
    id: "4",
    title: "TimeWall",
    subtitle: "",
    amount: "",
    image: "/assets/images/görev_ortakları/4.png",
    imageAlt: "TimeWall",
    rating: 5,
    rewards: [
      { amount: 'Değişken', label: 'Görev Tamamlama', completed: false },
    ],
    description: {
      title: 'Açıklama',
      description: 'TimeWall partneri ile çeşitli görevleri tamamlayarak ödül kazanın.'
    }
  }
]

export const surveyPartners: OfferCardData[] = [
  {
    id: "1",
    title: "BitLabs",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/1.png",
    imageAlt: "BitLabs",
    rating: 5
  },
  {
    id: "2",
    title: "CPX Research",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/2.png",
    imageAlt: "CPX Research",
    rating: 5
  },
  {
    id: "3",
    title: "Your-Surveys",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/3.png",
    imageAlt: "Your-Surveys",
    rating: 5
  },
  {
    id: "4",
    title: "Inbrain",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/4.png",
    imageAlt: "Inbrain",
    rating: 5
  },
  {
    id: "5",
    title: "Pollfish",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/5.png",
    imageAlt: "Pollfish",
    rating: 5
  },
  {
    id: "6",
    title: "Prime Surveys",
    subtitle: "",
    amount: "",
    image: "/assets/images/anket_işortakları/6.png",
    imageAlt: "Prime Surveys",
    rating: 5
  }
]
