/**
 * Micro Tasks Data
 * Separation of Concerns: Data layer
 */

import { IconName } from "@/lib/icons"

export interface MicroTask {
  id: string
  platform: string
  platformIcon: string
  title: string
  description: string
  reward: string
  completionRate: string
  totalSlots: number
  remainingSlots: number
  badges?: {
    icon: IconName
    value: string
  }[]
}

export const microTasks: MicroTask[] = [
  // Instagram Görevleri (15 adet)
  {
    id: "1",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram üzerinden 1.500 Takip Görevi",
    description: "Belirtilen hesabı takip edin ve ekran görüntüsü yükleyin",
    reward: "12.50₺",
    completionRate: "675/1000",
    totalSlots: 1000,
    remainingSlots: 325,
    badges: [{ icon: "si:money-fill", value: "12.50₺" }]
  },
  {
    id: "2",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Story İzleme Görevi",
    description: "Hikaye izleyin ve ekran görüntüsü atın",
    reward: "",
    completionRate: "450/800",
    totalSlots: 800,
    remainingSlots: 350,
    badges: [{ icon: "ph:star-four-fill", value: "450" }]
  },
  {
    id: "3",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Beğeni Görevi",
    description: "Son 10 gönderiyi beğenin",
    reward: "15.50₺",
    completionRate: "890/1200",
    totalSlots: 1200,
    remainingSlots: 310,
    badges: [{ icon: "si:money-fill", value: "15.50₺" }]
  },
  {
    id: "4",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Yorum Yapma Görevi",
    description: "Belirlenen gönderiye yorum yapın",
    reward: "",
    completionRate: "320/600",
    totalSlots: 600,
    remainingSlots: 280,
    badges: [{ icon: "ph:star-four-fill", value: "550" }]
  },
  {
    id: "5",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Reels İzleme",
    description: "Belirtilen reels videolarını izleyin",
    reward: "8.75₺",
    completionRate: "750/1000",
    totalSlots: 1000,
    remainingSlots: 250,
    badges: [{ icon: "si:money-fill", value: "8.75₺" }]
  },
  {
    id: "6",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Kaydet Görevi",
    description: "Gönderiyi kaydedin ve ekran görüntüsü atın",
    reward: "",
    completionRate: "580/900",
    totalSlots: 900,
    remainingSlots: 320,
    badges: [{ icon: "ph:star-four-fill", value: "380" }]
  },
  {
    id: "7",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Paylaşım Görevi",
    description: "Story'de paylaş ve etiketle",
    reward: "18.90₺",
    completionRate: "430/700",
    totalSlots: 700,
    remainingSlots: 270,
    badges: [{ icon: "si:money-fill", value: "18.90₺" }]
  },
  {
    id: "8",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Profil Görüntüleme",
    description: "Profili ziyaret edin ve 30 saniye bekleyin",
    reward: "",
    completionRate: "920/1100",
    totalSlots: 1100,
    remainingSlots: 180,
    badges: [{ icon: "ph:star-four-fill", value: "290" }]
  },
  {
    id: "9",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram DM Gönderme",
    description: "Belirtilen mesajı gönderin",
    reward: "22.50₺",
    completionRate: "210/500",
    totalSlots: 500,
    remainingSlots: 290,
    badges: [{ icon: "si:money-fill", value: "22.50₺" }]
  },
  {
    id: "10",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Highlights İzleme",
    description: "Tüm öne çıkanları izleyin",
    reward: "",
    completionRate: "560/850",
    totalSlots: 850,
    remainingSlots: 290,
    badges: [{ icon: "ph:star-four-fill", value: "420" }]
  },
  {
    id: "11",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Canlı Yayın İzleme",
    description: "Canlı yayını 5 dakika izleyin",
    reward: "14.25₺",
    completionRate: "340/600",
    totalSlots: 600,
    remainingSlots: 260,
    badges: [{ icon: "si:money-fill", value: "14.25₺" }]
  },
  {
    id: "12",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Anket Görevi",
    description: "Story anketine katılın",
    reward: "",
    completionRate: "780/1000",
    totalSlots: 1000,
    remainingSlots: 220,
    badges: [{ icon: "ph:star-four-fill", value: "350" }]
  },
  {
    id: "13",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Soru Cevaplama",
    description: "Story sorusunu cevaplayın",
    reward: "16.80₺",
    completionRate: "490/800",
    totalSlots: 800,
    remainingSlots: 310,
    badges: [{ icon: "si:money-fill", value: "16.80₺" }]
  },
  {
    id: "14",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Etiketleme Görevi",
    description: "3 arkadaşınızı etiketleyin",
    reward: "",
    completionRate: "650/950",
    totalSlots: 950,
    remainingSlots: 300,
    badges: [{ icon: "ph:star-four-fill", value: "480" }]
  },
  {
    id: "15",
    platform: "Instagram",
    platformIcon: "/assets/images/denizbank.png",
    title: "Instagram Video İzleme",
    description: "IGTV videosunu sonuna kadar izleyin",
    reward: "11.90₺",
    completionRate: "820/1100",
    totalSlots: 1100,
    remainingSlots: 280,
    badges: [{ icon: "si:money-fill", value: "11.90₺" }]
  },

  // TikTok Görevleri (10 adet)
  {
    id: "16",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Takip Görevi",
    description: "Hesabı takip edin ve ekran görüntüsü atın",
    reward: "13.50₺",
    completionRate: "540/900",
    totalSlots: 900,
    remainingSlots: 360,
    badges: [{ icon: "si:money-fill", value: "13.50₺" }]
  },
  {
    id: "17",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Video Beğeni",
    description: "Son 5 videoyu beğenin",
    reward: "",
    completionRate: "720/1000",
    totalSlots: 1000,
    remainingSlots: 280,
    badges: [{ icon: "ph:star-four-fill", value: "390" }]
  },
  {
    id: "18",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Yorum Yapma",
    description: "Videoya yorum yapın",
    reward: "17.25₺",
    completionRate: "380/700",
    totalSlots: 700,
    remainingSlots: 320,
    badges: [{ icon: "si:money-fill", value: "17.25₺" }]
  },
  {
    id: "19",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Video Paylaşımı",
    description: "Videoyu paylaşın ve etiketleyin",
    reward: "",
    completionRate: "610/850",
    totalSlots: 850,
    remainingSlots: 240,
    badges: [{ icon: "ph:star-four-fill", value: "520" }]
  },
  {
    id: "20",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Favorilere Ekleme",
    description: "Videoyu favorilerinize ekleyin",
    reward: "9.90₺",
    completionRate: "890/1100",
    totalSlots: 1100,
    remainingSlots: 210,
    badges: [{ icon: "si:money-fill", value: "9.90₺" }]
  },
  {
    id: "21",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Canlı Yayın İzleme",
    description: "Canlı yayını 10 dakika izleyin",
    reward: "",
    completionRate: "450/750",
    totalSlots: 750,
    remainingSlots: 300,
    badges: [{ icon: "ph:star-four-fill", value: "460" }]
  },
  {
    id: "22",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Duet Görevi",
    description: "Videoyla duet çekin",
    reward: "24.50₺",
    completionRate: "280/600",
    totalSlots: 600,
    remainingSlots: 320,
    badges: [{ icon: "si:money-fill", value: "24.50₺" }]
  },
  {
    id: "23",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Stitch Görevi",
    description: "Videoyu stitch yapın",
    reward: "",
    completionRate: "530/800",
    totalSlots: 800,
    remainingSlots: 270,
    badges: [{ icon: "ph:star-four-fill", value: "410" }]
  },
  {
    id: "24",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Ses Kullanımı",
    description: "Belirtilen sesi kullanarak video çekin",
    reward: "28.75₺",
    completionRate: "190/500",
    totalSlots: 500,
    remainingSlots: 310,
    badges: [{ icon: "si:money-fill", value: "28.75₺" }]
  },
  {
    id: "25",
    platform: "TikTok",
    platformIcon: "/assets/images/denizbank.png",
    title: "TikTok Hashtag Kullanımı",
    description: "Belirtilen hashtag'i kullanın",
    reward: "",
    completionRate: "670/950",
    totalSlots: 950,
    remainingSlots: 280,
    badges: [{ icon: "ph:star-four-fill", value: "380" }]
  },

  // YouTube Görevleri (10 adet)
  {
    id: "26",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Abone Olma Görevi",
    description: "Kanala abone olun ve bildirimleri açın",
    reward: "15.75₺",
    completionRate: "820/1100",
    totalSlots: 1100,
    remainingSlots: 280,
    badges: [{ icon: "si:money-fill", value: "15.75₺" }]
  },
  {
    id: "27",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Video İzleme",
    description: "Videoyu sonuna kadar izleyin",
    reward: "",
    completionRate: "950/1200",
    totalSlots: 1200,
    remainingSlots: 250,
    badges: [{ icon: "ph:star-four-fill", value: "340" }]
  },
  {
    id: "28",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Beğeni Görevi",
    description: "Videoyu beğenin",
    reward: "8.50₺",
    completionRate: "780/1000",
    totalSlots: 1000,
    remainingSlots: 220,
    badges: [{ icon: "si:money-fill", value: "8.50₺" }]
  },
  {
    id: "29",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Yorum Yapma",
    description: "Videoya yorum yapın",
    reward: "",
    completionRate: "540/850",
    totalSlots: 850,
    remainingSlots: 310,
    badges: [{ icon: "ph:star-four-fill", value: "490" }]
  },
  {
    id: "30",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Paylaşım Görevi",
    description: "Videoyu sosyal medyada paylaşın",
    reward: "19.90₺",
    completionRate: "410/700",
    totalSlots: 700,
    remainingSlots: 290,
    badges: [{ icon: "si:money-fill", value: "19.90₺" }]
  },
  {
    id: "31",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Playlist Oluşturma",
    description: "Videoyu playlist'e ekleyin",
    reward: "",
    completionRate: "690/950",
    totalSlots: 950,
    remainingSlots: 260,
    badges: [{ icon: "ph:star-four-fill", value: "370" }]
  },
  {
    id: "32",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Canlı Yayın İzleme",
    description: "Canlı yayını 15 dakika izleyin",
    reward: "21.50₺",
    completionRate: "330/650",
    totalSlots: 650,
    remainingSlots: 320,
    badges: [{ icon: "si:money-fill", value: "21.50₺" }]
  },
  {
    id: "33",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Community Etkileşimi",
    description: "Community gönderisine yanıt verin",
    reward: "",
    completionRate: "870/1100",
    totalSlots: 1100,
    remainingSlots: 230,
    badges: [{ icon: "ph:star-four-fill", value: "420" }]
  },
  {
    id: "34",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Shorts İzleme",
    description: "10 shorts videosu izleyin",
    reward: "12.25₺",
    completionRate: "620/900",
    totalSlots: 900,
    remainingSlots: 280,
    badges: [{ icon: "si:money-fill", value: "12.25₺" }]
  },
  {
    id: "35",
    platform: "YouTube",
    platformIcon: "/assets/images/denizbank.png",
    title: "YouTube Premium Deneme",
    description: "Premium'u deneyin ve ekran görüntüsü atın",
    reward: "",
    completionRate: "450/800",
    totalSlots: 800,
    remainingSlots: 350,
    badges: [{ icon: "ph:star-four-fill", value: "550" }]
  },

  // Twitter Görevleri (10 adet)
  {
    id: "36",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Takip Görevi",
    description: "Hesabı takip edin",
    reward: "14.90₺",
    completionRate: "760/1000",
    totalSlots: 1000,
    remainingSlots: 240,
    badges: [{ icon: "si:money-fill", value: "14.90₺" }]
  },
  {
    id: "37",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Retweet Görevi",
    description: "Tweet'i retweet edin",
    reward: "",
    completionRate: "590/850",
    totalSlots: 850,
    remainingSlots: 260,
    badges: [{ icon: "ph:star-four-fill", value: "390" }]
  },
  {
    id: "38",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Beğeni Görevi",
    description: "Son 10 tweet'i beğenin",
    reward: "10.50₺",
    completionRate: "880/1100",
    totalSlots: 1100,
    remainingSlots: 220,
    badges: [{ icon: "si:money-fill", value: "10.50₺" }]
  },
  {
    id: "39",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Yanıt Görevi",
    description: "Tweet'e yanıt yazın",
    reward: "",
    completionRate: "420/700",
    totalSlots: 700,
    remainingSlots: 280,
    badges: [{ icon: "ph:star-four-fill", value: "470" }]
  },
  {
    id: "40",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Alıntılama Görevi",
    description: "Tweet'i alıntılayarak paylaşın",
    reward: "18.75₺",
    completionRate: "350/650",
    totalSlots: 650,
    remainingSlots: 300,
    badges: [{ icon: "si:money-fill", value: "18.75₺" }]
  },
  {
    id: "41",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Space Katılımı",
    description: "Space'e katılın ve 10 dakika kalın",
    reward: "",
    completionRate: "280/550",
    totalSlots: 550,
    remainingSlots: 270,
    badges: [{ icon: "ph:star-four-fill", value: "520" }]
  },
  {
    id: "42",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Liste Oluşturma",
    description: "Belirtilen hesapları listeye ekleyin",
    reward: "16.25₺",
    completionRate: "510/800",
    totalSlots: 800,
    remainingSlots: 290,
    badges: [{ icon: "si:money-fill", value: "16.25₺" }]
  },
  {
    id: "43",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Anket Oylaması",
    description: "Ankete oy verin",
    reward: "",
    completionRate: "920/1100",
    totalSlots: 1100,
    remainingSlots: 180,
    badges: [{ icon: "ph:star-four-fill", value: "310" }]
  },
  {
    id: "44",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Yer İmleri Görevi",
    description: "Tweet'i yer imlerine ekleyin",
    reward: "7.90₺",
    completionRate: "650/900",
    totalSlots: 900,
    remainingSlots: 250,
    badges: [{ icon: "si:money-fill", value: "7.90₺" }]
  },
  {
    id: "45",
    platform: "Twitter",
    platformIcon: "/assets/images/denizbank.png",
    title: "Twitter Profil Ziyareti",
    description: "Profili ziyaret edin ve 30 saniye bekleyin",
    reward: "",
    completionRate: "740/1000",
    totalSlots: 1000,
    remainingSlots: 260,
    badges: [{ icon: "ph:star-four-fill", value: "360" }]
  }
]
