/**
 * Macro Tasks Data
 * Separation of Concerns: Data layer
 * Makro görev verilerini tek bir yerden yönetir
 */

export interface TaskRequirement {
  title: string;
  description: string;
}

export interface MacroTask {
  id: string;
  title: string;
  subtitle: string;
  amount: string;
  image: string;
  imageAlt: string;
  category?: string;
  rating?: number;
  rewards?: { amount: string; label: string; completed: boolean }[];
  detail?: string;
  newMembers?: TaskRequirement;
  taskFlexibility?: TaskRequirement;
  description?: TaskRequirement;
}

export const allMacroTasks: MacroTask[] = [
  // Banking Tasks (15 items)

  {
    id: '1',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'green',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '2',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'green',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '3',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket1.png',
    imageAlt: 'YouTube Premium',
    rating: 5,
    category: 'green',
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '4',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'pink',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '5',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'pink',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '6',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket2.png',
    imageAlt: 'YouTube Premium',
    rating: 5,
    category: 'pink',
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '7',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'Spotify',
    rating: 5,
    category: 'yellow',
    rewards: [
      { amount: '25,00₺', label: 'Uygulama İndir', completed: true },
      { amount: '50,00₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50,00₺', label: '7 Gün Premium Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Spotify Premium üyeliğini başlat ve 7 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '8',
    title: 'Netflix',
    subtitle: 'Standart Paket',
    amount: '85.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'Netflix',
    rating: 4,
    category: 'yellow',
    rewards: [
      { amount: '20,00₺', label: 'Hesap Oluştur', completed: true },
      { amount: '30,00₺', label: 'İlk Ödemeyi Yap', completed: true },
      { amount: '35,00₺', label: '14 Gün Aktif Kullan', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    description: {
      title: 'Açıklama',
      description: 'Netflix hesabı oluştur, ödeme yap ve 14 gün aktif kullanarak ödülünü kazan.'
    }
  },
  {
    id: '3',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '95.00₺',
    image: '/assets/images/anket3.png',
    imageAlt: 'YouTube Premium',
    category: 'yellow',
    rating: 5,
    rewards: [
      { amount: '30,00₺', label: 'Aile Üyeliği Başlat', completed: true },
      { amount: '65,00₺', label: '30 Gün Aktif Kullan', completed: false },
    ],
    newMembers: {
      title: 'Sadece Yeni Üyeler',
      description: 'Cihazına daha öncesinden bu uygulamayı hiç yüklememiş olan yeni kullanıcılar ödül kazanabilir.'
    },
    description: {
      title: 'Açıklama',
      description: 'YouTube Premium aile üyeliğini başlat ve 30 gün kullanarak ödülünü kazan.'
    }
  },
  {
    id: '1',
    title: 'Denizbank',
    subtitle: 'Torox Premium',
    amount: '435.23₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Denizbank',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '150₺', label: 'Hesap Açma', completed: true },
      { amount: '100₺', label: 'İlk Para Yatırma', completed: true },
      { amount: '85₺', label: 'Kart Aktivasyonu', completed: false },
      { amount: '50₺', label: 'İlk İşlem', completed: false },
      { amount: '50.23₺', label: 'Bonus Tamamlama', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırası ile tamamlamanız gerekmiyor.'
    },
    newMembers: {
      title: 'Sadece Yeni Müşteriler',
      description: 'Bu kampanya Denizbank\'ta daha önce hesabı olmayan yeni müşterilere özeldir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Denizbank Torox Premium hesap açın ve belirtilen adımları tamamlayarak toplam 435.23₺ kazanın. Yeni müşterilere özel kampanya.'
    }
  },
  {
    id: '2',
    title: 'Garanti BBVA',
    subtitle: 'Bonus Hesap',
    amount: '620.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Garanti BBVA',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '200₺', label: 'Hesap Açma', completed: true },
      { amount: '150₺', label: 'Bonus Kart Başvurusu', completed: false },
      { amount: '120.50₺', label: 'Minimum 1000₺ Harcama', completed: false },
      { amount: '100₺', label: 'Otomatik Ödeme Talimatı', completed: false },
      { amount: '50₺', label: 'Mobil Uygulama Kullanımı', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları istediğiniz sırada tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Sadece Yeni Müşteriler',
      description: 'Garanti BBVA\'da daha önce hesabı olmayan yeni müşterilere özeldir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Garanti BBVA Bonus hesap açın, kart başvurusu yapın ve belirtilen işlemleri tamamlayarak 620.50₺ kazanın.'
    }
  },
  {
    id: '3',
    title: 'İş Bankası',
    subtitle: 'Maximum Kart',
    amount: '845.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'İş Bankası',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '250₺', label: 'Hesap Açma', completed: true },
      { amount: '200₺', label: 'Maximum Kart Başvurusu', completed: true },
      { amount: '195.75₺', label: '2000₺ Harcama', completed: false },
      { amount: '100₺', label: 'Otomatik Ödeme', completed: false },
      { amount: '100₺', label: 'İnternet Bankacılığı', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları istediğiniz sırada tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Kampanyası',
      description: 'İş Bankası\'nda ilk kez hesap açan müşteriler için geçerlidir.'
    },
    description: {
      title: 'Açıklama',
      description: 'İş Bankası Maximum Kart başvurusu yapın ve belirtilen harcama hedeflerini tamamlayarak 845.75₺ kazanın.'
    }
  },
  {
    id: '4',
    title: 'Yapı Kredi',
    subtitle: 'World Card',
    amount: '725.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Yapı Kredi',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '200₺', label: 'World Kart Başvurusu', completed: true },
      { amount: '175₺', label: '1500₺ Minimum Harcama', completed: false },
      { amount: '150₺', label: 'Otomatik Ödeme Talimatı', completed: false },
      { amount: '100₺', label: 'Worldpuan Aktivasyonu', completed: false },
      { amount: '100₺', label: 'İlk Taksitli İşlem', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Görev adımlarını istediğiniz sırada gerçekleştirebilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Avantajı',
      description: 'Yapı Kredi\'de daha önce kredi kartı olmayan müşteriler için özel kampanya.'
    },
    description: {
      title: 'Açıklama',
      description: 'Yapı Kredi World Card başvurusu yapın, onaylandıktan sonra minimum harcama hedefini tutturun ve tüm adımları tamamlayarak 725₺ kazanın. Worldpuan avantajlarından yararlanın.'
    }
  },
  {
    id: '5',
    title: 'Akbank',
    subtitle: 'Axess Kart',
    amount: '550.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Akbank',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '150₺', label: 'Hesap Açma', completed: true },
      { amount: '120₺', label: 'Axess Kart Başvurusu', completed: true },
      { amount: '130.25₺', label: '1200₺ Harcama', completed: false },
      { amount: '75₺', label: 'Akbank Mobil Kullanımı', completed: false },
      { amount: '75₺', label: 'Chip Para Aktivasyonu', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Görevleri dilediğiniz sırada tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Fırsatı',
      description: 'Akbank\'ta daha önce hesabı olmayan yeni müşteriler için özel kampanya.'
    },
    description: {
      title: 'Açıklama',
      description: 'Akbank hesabı açın, Axess Kart başvurusu yapın ve belirtilen harcama hedefini tutturarak 550.25₺ kazanın. Chip Para ile ekstra avantajlar elde edin.'
    }
  },
  {
    id: '6',
    title: 'QNB Finansbank',
    subtitle: 'Enpara Hesap',
    amount: '395.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'QNB Finansbank',
    category: 'banking',
    rating: 3,
    rewards: [
      { amount: '100₺', label: 'Enpara Hesap Açma', completed: true },
      { amount: '95₺', label: 'Minimum 500₺ Bakiye', completed: false },
      { amount: '100₺', label: 'Dijital Kart Kullanımı', completed: false },
      { amount: '100₺', label: '3 Fatura Ödemesi', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'İstediğiniz sırada görevleri tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Dijital Banka Avantajı',
      description: 'Enpara.com\'da ilk kez hesap açan kullanıcılar için geçerlidir.'
    },
    description: {
      title: 'Açıklama',
      description: 'QNB Finansbank Enpara hesabı açın, minimum bakiye tutun ve dijital kart kullanarak 395₺ kazanın. Tamamen dijital bankacılık deneyimi.'
    }
  },
  {
    id: '7',
    title: 'TEB',
    subtitle: 'Bonus Plus',
    amount: '480.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'TEB',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '120₺', label: 'Hesap Açma', completed: true },
      { amount: '120.50₺', label: 'Bonus Plus Kart', completed: false },
      { amount: '110₺', label: '1000₺ Harcama', completed: false },
      { amount: '80₺', label: 'TEB Mobil İşlem', completed: false },
      { amount: '50₺', label: 'BonusPlus Kazanımı', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Adımları sırasıyla tamamlamanız gerekmiyor.'
    },
    newMembers: {
      title: 'Yeni Müşteri Kampanyası',
      description: 'TEB\'de ilk kez hesap açan müşteriler için özel fırsat.'
    },
    description: {
      title: 'Açıklama',
      description: 'TEB Bonus Plus kart başvurusu yapın, harcama hedefini tutturun ve mobil bankacılık ile 480.50₺ kazanın. BonusPlus puanlarınızı biriktirin.'
    }
  },
  {
    id: '8',
    title: 'Halkbank',
    subtitle: 'Paraf Kart',
    amount: '520.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Halkbank',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '140₺', label: 'Hesap Açma', completed: true },
      { amount: '130.75₺', label: 'Paraf Kart Başvurusu', completed: false },
      { amount: '120₺', label: '1100₺ Harcama', completed: false },
      { amount: '80₺', label: 'Paraf Puan Kullanımı', completed: false },
      { amount: '50₺', label: 'İnternet Şubesi', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Görev adımlarını istediğiniz sırada gerçekleştirebilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Bonusu',
      description: 'Halkbank\'ta daha önce kredi kartı olmayan yeni müşteriler için.'
    },
    description: {
      title: 'Açıklama',
      description: 'Halkbank Paraf Kart başvurusu yapın, minimum harcama yapın ve Paraf puanlarınızı kullanarak 520.75₺ kazanın.'
    }
  },
  {
    id: '9',
    title: 'Ziraat Bankası',
    subtitle: 'Bankkart Combo',
    amount: '465.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Ziraat Bankası',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '120₺', label: 'Hesap Açma', completed: true },
      { amount: '115₺', label: 'Bankkart Combo Başvurusu', completed: true },
      { amount: '110₺', label: '900₺ Harcama', completed: false },
      { amount: '70₺', label: 'Mobil Bankacılık', completed: false },
      { amount: '50₺', label: 'Havale/EFT İşlemi', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'Görevleri dilediğiniz sırada tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Avantajı',
      description: 'Ziraat Bankası\'nda ilk kez hesap açan müşteriler için özel kampanya.'
    },
    description: {
      title: 'Açıklama',
      description: 'Ziraat Bankası Bankkart Combo başvurusu yapın, belirtilen işlemleri gerçekleştirin ve 465₺ kazanın. Türkiye\'nin en yaygın şube ağı.'
    }
  },
  {
    id: '10',
    title: 'Vakıfbank',
    subtitle: 'World Kart',
    amount: '590.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Vakıfbank',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '150₺', label: 'Hesap Açma', completed: true },
      { amount: '140.25₺', label: 'World Kart Başvurusu', completed: false },
      { amount: '150₺', label: '1400₺ Harcama', completed: false },
      { amount: '100₺', label: 'Eft Havale', completed: false },
      { amount: '50₺', label: 'Mobil İşlem', completed: false },
    ],
    taskFlexibility: {
      title: 'Görev esnekliği',
      description: 'İstediğiniz sırada görev adımlarını tamamlayabilirsiniz.'
    },
    newMembers: {
      title: 'Yeni Müşteri Kampanyası',
      description: 'Vakıfbank\'ta daha önce hesabı olmayan yeni müşteriler için geçerlidir.'
    },
    description: {
      title: 'Açıklama',
      description: 'Vakıfbank World Kart başvurusu yapın, harcama hedeflerinizi tutturun ve dijital bankacılık ile 590.25₺ kazanın.'
    }
  },
  {
    id: '11',
    title: 'ING Bank',
    subtitle: 'Turuncu Hesap',
    amount: '410.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'ING Bank',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '110₺', label: 'Turuncu Hesap Açma', completed: true },
      { amount: '100₺', label: 'Minimum 1000₺ Bakiye', completed: true },
      { amount: '100₺', label: 'Maaş/Gelir Transferi', completed: false },
      { amount: '100₺', label: 'ING Mobil Kullanımı', completed: false },
    ],
    detail: 'ING Bank Turuncu Hesap açın, maaş transferi yapın ve tamamen dijital bankacılık hizmetleri ile 410₺ kazanın. Şubesiz modern bankacılık.'
  },
  {
    id: '12',
    title: 'Alternatifbank',
    subtitle: 'Alo Kart',
    amount: '375.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Alternatifbank',
    category: 'banking',
    rating: 3,
    rewards: [
      { amount: '100₺', label: 'Hesap Açma', completed: true },
      { amount: '90.50₺', label: 'Alo Kart Başvurusu', completed: false },
      { amount: '95₺', label: '800₺ Harcama', completed: false },
      { amount: '90₺', label: 'Mobil Uygulama', completed: false },
    ],
    detail: 'Alternatifbank Alo Kart başvurusu yapın, minimum harcama yapın ve mobil uygulama kullanarak 375.50₺ kazanın.'
  },
  {
    id: '13',
    title: 'Fibabanka',
    subtitle: 'Bonus Kart',
    amount: '445.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Fibabanka',
    category: 'banking',
    rating: 4,
    rewards: [
      { amount: '115₺', label: 'Hesap Açma', completed: true },
      { amount: '110.75₺', label: 'Bonus Kart Başvurusu', completed: false },
      { amount: '110₺', label: '950₺ Harcama', completed: false },
      { amount: '60₺', label: 'Fibabanka Mobil', completed: false },
      { amount: '50₺', label: 'Fatura Ödemesi', completed: false },
    ],
    detail: 'Fibabanka Bonus Kart başvurusu yapın, harcama hedefini tutturun ve mobil bankacılık ile 445.75₺ kazanın.'
  },
  {
    id: '14',
    title: 'Şekerbank',
    subtitle: 'Paraf Kart',
    amount: '355.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Şekerbank',
    category: 'banking',
    rating: 3,
    rewards: [
      { amount: '90₺', label: 'Hesap Açma', completed: true },
      { amount: '90₺', label: 'Paraf Kart Başvurusu', completed: false },
      { amount: '95₺', label: '700₺ Harcama', completed: false },
      { amount: '80₺', label: 'Dijital İşlemler', completed: false },
    ],
    detail: 'Şekerbank Paraf Kart başvurusu yapın, belirtilen harcamayı gerçekleştirin ve 355₺ kazanın.'
  },
  {
    id: '15',
    title: 'HSBC',
    subtitle: 'Advance Hesap',
    amount: '675.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'HSBC',
    category: 'banking',
    rating: 5,
    rewards: [
      { amount: '175₺', label: 'Advance Hesap Açma', completed: true },
      { amount: '150.25₺', label: 'Kredi Kartı Başvurusu', completed: false },
      { amount: '150₺', label: '1600₺ Harcama', completed: false },
      { amount: '100₺', label: 'Yatırım Hesabı', completed: false },
      { amount: '100₺', label: 'Premier Banking', completed: false },
    ],
    detail: 'HSBC Advance hesabı açın, kredi kartı başvurusu yapın ve premium bankacılık hizmetlerinden yararlanarak 675.25₺ kazanın.'
  },

  // Tech Tasks (15 items)
  {
    id: '16',
    title: 'Spotify',
    subtitle: 'Premium Deneme',
    amount: '125.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Spotify',
    category: 'tech',
    rating: 5,
    rewards: [
      { amount: '25₺', label: 'Uygulama İndir', completed: true },
      { amount: '50₺', label: 'Premium Üyeliği Başlat', completed: true },
      { amount: '50₺', label: '7 Gün Aktif Kullan', completed: false },
    ],
    detail: 'Spotify Premium üyeliğini başlat ve 7 gün aktif olarak kullanarak toplam 125₺ kazanın. Müzik dinleme deneyiminizi geliştirin.'
  },
  {
    id: '17',
    title: 'Netflix',
    subtitle: 'Standart Plan',
    amount: '285.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Netflix',
    category: 'tech',
    rating: 5,
    rewards: [
      { amount: '50₺', label: 'Hesap Oluştur', completed: true },
      { amount: '100₺', label: 'Standart Plan Başlat', completed: false },
      { amount: '85.50₺', label: '14 Gün Aktif İzle', completed: false },
      { amount: '50₺', label: 'Profil Oluştur', completed: false },
    ],
    detail: 'Netflix Standart Plan üyeliğini başlatın, hesabınızı oluşturun ve 14 gün aktif olarak içerik izleyerek 285.50₺ kazanın.'
  },
  {
    id: '18',
    title: 'YouTube Premium',
    subtitle: 'Aile Paketi',
    amount: '195.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'YouTube Premium',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '40₺', label: 'Aile Paketi Başlat', completed: true },
      { amount: '75.75₺', label: '30 Gün Aktif Kullan', completed: false },
      { amount: '50₺', label: '5 Aile Üyesi Ekle', completed: false },
      { amount: '30₺', label: 'YouTube Music Kullan', completed: false },
    ],
    detail: 'YouTube Premium Aile Paketi başlatın, aile üyelerinizi ekleyin ve 30 gün aktif kullanarak 195.75₺ kazanın.'
  },
  {
    id: '19',
    title: 'Amazon Prime',
    subtitle: 'Aylık Üyelik',
    amount: '165.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Amazon Prime',
    category: 'tech',
    rating: 5,
    rewards: [
      { amount: '35₺', label: 'Prime Üyeliği Başlat', completed: true },
      { amount: '50₺', label: 'Prime Video İzle', completed: false },
      { amount: '40₺', label: 'Ücretsiz Kargo Kullan', completed: false },
      { amount: '40₺', label: '30 Gün Aktif Kal', completed: false },
    ],
    detail: 'Amazon Prime üyeliği başlatın, Prime Video izleyin ve ücretsiz kargo avantajlarından yararlanarak 165₺ kazanın. Müzik ve kitap hizmetleri dahil.'
  },
  {
    id: '20',
    title: 'Disney+',
    subtitle: 'Yıllık Paket',
    amount: '215.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Disney+',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '50₺', label: 'Hesap Oluştur', completed: true },
      { amount: '65.25₺', label: 'Yıllık Abonelik', completed: false },
      { amount: '50₺', label: '10 Farklı İçerik İzle', completed: false },
      { amount: '50₺', label: 'Profil Oluştur', completed: false },
    ],
    detail: 'Disney+ yıllık abonelik başlatın, Disney, Pixar, Marvel, Star Wars ve National Geographic içeriklerini izleyerek 215.25₺ kazanın.'
  },
  {
    id: '21',
    title: 'Apple Music',
    subtitle: 'Öğrenci Paketi',
    amount: '95.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Apple Music',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '25₺', label: 'Öğrenci Doğrulama', completed: true },
      { amount: '35.50₺', label: 'Abonelik Başlat', completed: false },
      { amount: '35₺', label: '5 Çalma Listesi Oluştur', completed: false },
    ],
    detail: 'Apple Music öğrenci paketine abone olun, öğrenci doğrulaması yapın ve çalma listeleri oluşturarak 95.50₺ kazanın.'
  },
  {
    id: '22',
    title: 'Exxen',
    subtitle: 'Premium Üyelik',
    amount: '145.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Exxen',
    category: 'tech',
    rating: 3,
    rewards: [
      { amount: '30₺', label: 'Hesap Oluştur', completed: true },
      { amount: '50₺', label: 'Premium Üyelik Başlat', completed: false },
      { amount: '40₺', label: '5 Farklı İçerik İzle', completed: false },
      { amount: '25₺', label: '14 Gün Aktif Kal', completed: false },
    ],
    detail: 'Exxen Premium üyeliği başlatın, yerli ve yabancı diziler izleyin ve spor yayınlarından yararlanarak 145₺ kazanın.'
  },
  {
    id: '23',
    title: 'Blu TV',
    subtitle: 'Aylık Abonelik',
    amount: '115.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Blu TV',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '30₺', label: 'Hesap Oluştur', completed: true },
      { amount: '40.75₺', label: 'Aylık Abonelik', completed: false },
      { amount: '30₺', label: 'Orijinal İçerik İzle', completed: false },
      { amount: '15₺', label: '7 Gün Aktif Kullan', completed: false },
    ],
    detail: 'Blu TV aylık abonelik başlatın, Türkiye\'nin özgün içeriklerini izleyin ve 115.75₺ kazanın.'
  },
  {
    id: '24',
    title: 'Gain',
    subtitle: 'Premium Plus',
    amount: '135.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Gain',
    category: 'tech',
    rating: 3,
    rewards: [
      { amount: '35₺', label: 'Hesap Oluştur', completed: true },
      { amount: '50₺', label: 'Premium Plus Başlat', completed: false },
      { amount: '30₺', label: 'Oyun İçeriği İzle', completed: false },
      { amount: '20₺', label: '10 Gün Aktif Kal', completed: false },
    ],
    detail: 'Gain Premium Plus üyeliği başlatın, oyun ve espor içeriklerini izleyerek 135₺ kazanın.'
  },
  {
    id: '25',
    title: 'Twitch',
    subtitle: 'Turbo Üyelik',
    amount: '105.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Twitch',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '30₺', label: 'Hesap Oluştur', completed: true },
      { amount: '40.25₺', label: 'Turbo Üyelik Başlat', completed: false },
      { amount: '20₺', label: '3 Farklı Yayıncı İzle', completed: false },
      { amount: '15₺', label: 'Reklamsız İzleme', completed: false },
    ],
    detail: 'Twitch Turbo üyeliği başlatın, reklamsız canlı yayınlar izleyin ve özel emote\'lara erişerek 105.25₺ kazanın.'
  },
  {
    id: '26',
    title: 'Deezer',
    subtitle: 'Premium Aile',
    amount: '155.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Deezer',
    category: 'tech',
    rating: 3,
    rewards: [
      { amount: '40₺', label: 'Aile Paketi Başlat', completed: true },
      { amount: '50.50₺', label: '6 Profil Oluştur', completed: false },
      { amount: '40₺', label: 'Çalma Listeleri', completed: false },
      { amount: '25₺', label: '30 Gün Kullan', completed: false },
    ],
    detail: 'Deezer Premium Aile paketi başlatın, 6 aile üyesi ekleyin ve müzik keyfini paylaşarak 155.50₺ kazanın.'
  },
  {
    id: '27',
    title: 'HBO Max',
    subtitle: 'Aylık Plan',
    amount: '175.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'HBO Max',
    category: 'tech',
    rating: 5,
    rewards: [
      { amount: '40₺', label: 'Hesap Oluştur', completed: true },
      { amount: '60₺', label: 'Aylık Abonelik Başlat', completed: false },
      { amount: '50₺', label: 'HBO Orijinal İzle', completed: false },
      { amount: '25₺', label: '14 Gün Aktif Kal', completed: false },
    ],
    detail: 'HBO Max aylık abonelik başlatın, ödüllü HBO orijinal içeriklerini ve Warner Bros. filmlerini izleyerek 175₺ kazanın.'
  },
  {
    id: '28',
    title: 'Paramount+',
    subtitle: 'Premium Paket',
    amount: '125.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Paramount+',
    category: 'tech',
    rating: 3,
    rewards: [
      { amount: '30₺', label: 'Hesap Oluştur', completed: true },
      { amount: '45.75₺', label: 'Premium Abonelik', completed: false },
      { amount: '30₺', label: 'Paramount İçerik İzle', completed: false },
      { amount: '20₺', label: '10 Gün Kullan', completed: false },
    ],
    detail: 'Paramount+ Premium aboneliği başlatın, Paramount Pictures ve CBS içeriklerini izleyerek 125.75₺ kazanın.'
  },
  {
    id: '29',
    title: 'Audible',
    subtitle: 'Sesli Kitap',
    amount: '85.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Audible',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '20₺', label: 'Hesap Oluştur', completed: true },
      { amount: '35₺', label: 'Aylık Üyelik Başlat', completed: false },
      { amount: '30₺', label: '2 Sesli Kitap Dinle', completed: false },
    ],
    detail: 'Audible üyeliği başlatın, sesli kitap kütüphanesine erişin ve 2 kitap dinleyerek 85₺ kazanın.'
  },
  {
    id: '30',
    title: 'Storytel',
    subtitle: 'Aylık Üyelik',
    amount: '95.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Storytel',
    category: 'tech',
    rating: 4,
    rewards: [
      { amount: '25₺', label: 'Hesap Oluştur', completed: true },
      { amount: '35.25₺', label: 'Aylık Abonelik', completed: false },
      { amount: '25₺', label: '3 Kitap Dinle', completed: false },
      { amount: '10₺', label: '14 Gün Kullan', completed: false },
    ],
    detail: 'Storytel aylık üyeliği başlatın, binlerce sesli kitaba ve e-kitaba erişerek 95.25₺ kazanın.'
  },

  // Survey Tasks (8 items)
  {
    id: '31',
    title: 'Market Araştırması',
    subtitle: 'Tüketici Anketi',
    amount: '45.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Survey',
    category: 'survey',
    rating: 4,
    rewards: [
      { amount: '15₺', label: 'Profil Bilgilerini Tamamla', completed: true },
      { amount: '30₺', label: '15 Dakikalık Anket', completed: false },
    ],
    detail: 'Market araştırması anketini tamamlayın. Tüketici alışkanlıklarınız hakkında sorular içerir. Ortalama 15 dakika sürer.'
  },
  {
    id: '32',
    title: 'Ürün Testi',
    subtitle: 'Kullanıcı Deneyimi',
    amount: '65.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Product Test',
    category: 'survey',
    rating: 5,
    rewards: [
      { amount: '20₺', label: 'Ürünü İncele', completed: true },
      { amount: '25.50₺', label: 'Kullanım Senaryosu', completed: false },
      { amount: '20₺', label: 'Geri Bildirim Formu', completed: false },
    ],
    detail: 'Yeni ürünü test edin ve detaylı geri bildirim sağlayın. Kullanım deneyiminizi paylaşarak 65.50₺ kazanın.'
  },
  {
    id: '33',
    title: 'Online Anket',
    subtitle: 'Genel Değerlendirme',
    amount: '35.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Online Survey',
    category: 'survey',
    rating: 3,
    rewards: [
      { amount: '10₺', label: 'Demografik Bilgiler', completed: true },
      { amount: '25.75₺', label: '10 Dakikalık Anket', completed: false },
    ],
    detail: 'Online genel değerlendirme anketini tamamlayın. Yaklaşık 10 dakika sürer. Günlük yaşam alışkanlıklarınız hakkında sorular içerir.'
  },
  {
    id: '34',
    title: 'Marka Anketi',
    subtitle: 'Farkındalık Ölçümü',
    amount: '55.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Brand Survey',
    category: 'survey',
    rating: 4,
    rewards: [
      { amount: '15₺', label: 'Marka Tanıma', completed: true },
      { amount: '20₺', label: 'Marka Tercihleri', completed: false },
      { amount: '20₺', label: 'Satın Alma Niyeti', completed: false },
    ],
    detail: 'Marka farkındalığı ve tercih anketi. Tanıdığınız markaları değerlendirin ve satın alma tercihlerinizi paylaşarak 55₺ kazanın.'
  },
  {
    id: '35',
    title: 'Mobil Uygulama',
    subtitle: 'Kullanıcı Anketi',
    amount: '75.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'App Survey',
    category: 'survey',
    rating: 5,
    rewards: [
      { amount: '20₺', label: 'Uygulama İndir', completed: true },
      { amount: '25.25₺', label: 'Kullanıcı Deneyimi Anketi', completed: false },
      { amount: '15₺', label: 'Özellik Değerlendirmesi', completed: false },
      { amount: '15₺', label: 'İyileştirme Önerileri', completed: false },
    ],
    detail: 'Mobil uygulamayı indirin, test edin ve kullanıcı deneyimi anketini tamamlayarak 75.25₺ kazanın. Uygulamayı en az 3 gün kullanmanız gerekir.'
  },
  {
    id: '36',
    title: 'Web Sitesi',
    subtitle: 'Kullanılabilirlik Testi',
    amount: '85.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Website Test',
    category: 'survey',
    rating: 4,
    rewards: [
      { amount: '25₺', label: 'Site Navigasyon Testi', completed: true },
      { amount: '30.50₺', label: 'Kullanıcı Arayüzü Anketi', completed: false },
      { amount: '20₺', label: 'Görev Tamamlama Testi', completed: false },
      { amount: '10₺', label: 'Genel Değerlendirme', completed: false },
    ],
    detail: 'Web sitesi kullanılabilirlik testine katılın. Belirtilen görevleri tamamlayın ve kullanım deneyiminizi paylaşarak 85.50₺ kazanın.'
  },
  {
    id: '37',
    title: 'Müşteri Memnuniyeti',
    subtitle: 'Hizmet Kalitesi',
    amount: '40.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Customer Survey',
    category: 'survey',
    rating: 3,
    rewards: [
      { amount: '15₺', label: 'Hizmet Deneyimi', completed: true },
      { amount: '25₺', label: 'Kalite Değerlendirmesi', completed: false },
    ],
    detail: 'Müşteri memnuniyeti anketi. Aldığınız hizmet kalitesini değerlendirin ve iyileştirme önerilerinizi paylaşarak 40₺ kazanın.'
  },
  {
    id: '38',
    title: 'Pazar Araştırması',
    subtitle: 'Trend Analizi',
    amount: '95.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Market Research',
    category: 'survey',
    rating: 5,
    rewards: [
      { amount: '25₺', label: 'Tüketici Trendleri', completed: true },
      { amount: '30.75₺', label: 'Ürün Kategorileri', completed: false },
      { amount: '20₺', label: 'Fiyat Algısı', completed: false },
      { amount: '20₺', label: 'Gelecek Beklentileri', completed: false },
    ],
    detail: 'Kapsamlı pazar araştırması anketine katılın. Tüketici trendleri, ürün tercihleri ve gelecek beklentilerinizi paylaşarak 95.75₺ kazanın. Yaklaşık 20 dakika sürer.'
  },

  // Social Media Tasks (7 items)
  {
    id: '39',
    title: 'Instagram',
    subtitle: 'Takipçi Kampanyası',
    amount: '95.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Instagram',
    category: 'social',
    rating: 5,
    rewards: [
      { amount: '20₺', label: 'Hesabı Takip Et', completed: true },
      { amount: '25.25₺', label: '3 Gönderiyi Beğen', completed: true },
      { amount: '25₺', label: 'Story Paylaş', completed: false },
      { amount: '25₺', label: '1 Hafta Takipte Kal', completed: false },
    ],
    detail: 'Instagram hesabını takip edin, gönderileri beğenin ve story paylaşarak 95.25₺ kazanın. Organik etkileşim gereklidir.'
  },
  {
    id: '40',
    title: 'TikTok',
    subtitle: 'Video Paylaşımı',
    amount: '115.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'TikTok',
    category: 'social',
    rating: 4,
    rewards: [
      { amount: '30₺', label: 'Hesabı Takip Et', completed: true },
      { amount: '35₺', label: 'Belirtilen Hashtag ile Video', completed: false },
      { amount: '30₺', label: '100+ Görüntüleme', completed: false },
      { amount: '20₺', label: '10+ Beğeni', completed: false },
    ],
    detail: 'TikTok hesabını takip edin, belirtilen hashtag ile video paylaşın ve etkileşim hedeflerini tutturarak 115₺ kazanın.'
  },
  {
    id: '41',
    title: 'Twitter',
    subtitle: 'Retweet Görevi',
    amount: '65.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Twitter',
    category: 'social',
    rating: 4,
    rewards: [
      { amount: '15₺', label: 'Hesabı Takip Et', completed: true },
      { amount: '25.50₺', label: 'Belirtilen Tweet\'i RT', completed: true },
      { amount: '15₺', label: 'Yorum Yap', completed: false },
      { amount: '10₺', label: '1 Hafta Takipte Kal', completed: false },
    ],
    detail: 'Twitter hesabını takip edin, belirtilen tweet\'i retweet edin ve yorum yaparak 65.50₺ kazanın.'
  },
  {
    id: '42',
    title: 'Facebook',
    subtitle: 'Sayfa Beğeni',
    amount: '75.75₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Facebook',
    category: 'social',
    rating: 3,
    rewards: [
      { amount: '20₺', label: 'Sayfayı Beğen', completed: true },
      { amount: '20.75₺', label: '5 Gönderiyi Paylaş', completed: false },
      { amount: '20₺', label: '10 Yorum Yap', completed: false },
      { amount: '15₺', label: '2 Hafta Takipte Kal', completed: false },
    ],
    detail: 'Facebook sayfasını beğenin, gönderileri paylaşın ve yorumlarla etkileşimde bulunarak 75.75₺ kazanın. Organik katılım şarttır.'
  },
  {
    id: '43',
    title: 'LinkedIn',
    subtitle: 'Bağlantı Kurma',
    amount: '105.00₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'LinkedIn',
    category: 'social',
    rating: 4,
    rewards: [
      { amount: '25₺', label: 'Profili Takip Et', completed: true },
      { amount: '30₺', label: 'Bağlantı İsteği Gönder', completed: false },
      { amount: '30₺', label: '3 Gönderiyi Paylaş', completed: false },
      { amount: '20₺', label: 'Profesyonel Yorum', completed: false },
    ],
    detail: 'LinkedIn profilini takip edin, bağlantı kurun ve profesyonel içeriklerle etkileşimde bulunarak 105₺ kazanın. İş dünyası odaklı paylaşımlar yapın.'
  },
  {
    id: '44',
    title: 'YouTube',
    subtitle: 'Kanal Aboneliği',
    amount: '85.25₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'YouTube',
    category: 'social',
    rating: 5,
    rewards: [
      { amount: '20₺', label: 'Kanala Abone Ol', completed: true },
      { amount: '25.25₺', label: '5 Video İzle', completed: true },
      { amount: '20₺', label: 'Bildirimleri Aç', completed: false },
      { amount: '20₺', label: '3 Yorum Yap', completed: false },
    ],
    detail: 'YouTube kanalına abone olun, videoları izleyin, yorum yapın ve bildirimleri açarak 85.25₺ kazanın. En az 5 farklı video izlemeniz gerekir.'
  },
  {
    id: '45',
    title: 'Pinterest',
    subtitle: 'Pin Oluşturma',
    amount: '55.50₺',
    image: '/assets/images/denizbank.png',
    imageAlt: 'Pinterest',
    category: 'social',
    rating: 3,
    rewards: [
      { amount: '15₺', label: 'Hesabı Takip Et', completed: true },
      { amount: '20.50₺', label: '10 Pin Kaydet', completed: false },
      { amount: '20₺', label: 'Pano Oluştur', completed: false },
    ],
    detail: 'Pinterest hesabını takip edin, ilgili pinleri kaydedin ve kendi panonuzu oluşturarak 55.50₺ kazanın. En az 10 farklı pin kaydetmeniz gerekir.'
  }
]
