/**
 * Validation Constants
 * SOLID Principle: SRP - Tek sorumluluk: Validation kuralları
 */

export const VALIDATION_RULES = {
  EMAIL: {
    PATTERN: /^[^\s@]+@[^\s@]+\.[^\s@]+$/,
    MIN_LENGTH: 5,
    MAX_LENGTH: 100,
  },
  PHONE: {
    PATTERN: /^(\+90|0)?[0-9]{10}$/,
    MIN_LENGTH: 10,
    MAX_LENGTH: 13,
  },
  PASSWORD: {
    MIN_LENGTH: 8,
    MAX_LENGTH: 50,
    PATTERN: /^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)[a-zA-Z\d@$!%*?&]{8,}$/,
  },
  VERIFICATION_CODE: {
    LENGTH: 6,
    PATTERN: /^\d{6}$/,
  },
  IBAN: {
    PATTERN: /^TR\d{24}$/,
    LENGTH: 26,
  },
  USERNAME: {
    MIN_LENGTH: 3,
    MAX_LENGTH: 20,
    PATTERN: /^[a-zA-Z0-9_]+$/,
  },
  AMOUNT: {
    MIN: 0,
    PATTERN: /^\d+(\.\d{1,2})?$/,
  },
} as const

export const ERROR_MESSAGES = {
  EMAIL_INVALID: 'Geçerli bir e-posta adresi girin',
  EMAIL_REQUIRED: 'E-posta adresi gereklidir',
  PHONE_INVALID: 'Geçerli bir telefon numarası girin',
  PHONE_REQUIRED: 'Telefon numarası gereklidir',
  PASSWORD_WEAK: 'Şifre en az 8 karakter, büyük harf, küçük harf ve rakam içermelidir',
  PASSWORD_MISMATCH: 'Şifreler eşleşmiyor',
  PASSWORD_REQUIRED: 'Şifre gereklidir',
  VERIFICATION_CODE_INVALID: '6 haneli doğrulama kodu girin',
  IBAN_INVALID: 'Geçerli bir IBAN numarası girin (TR ile başlamalı)',
  USERNAME_INVALID: 'Kullanıcı adı sadece harf, rakam ve _ içerebilir',
  AMOUNT_INVALID: 'Geçerli bir tutar girin',
  AMOUNT_TOO_LOW: 'Tutar çok düşük',
  REQUIRED: 'Bu alan zorunludur',
} as const
