/**
 * Bank Constants
 * SOLID Principle: SRP - Tek sorumluluk: Banka bilgileri
 */

export interface BankInfo {
  id: string
  name: string
  logo: string
}

export const BANKS: readonly BankInfo[] = [
  { id: 'ziraat', name: 'Ziraat Bankası', logo: '/assets/images/banks/ziraat.jpeg' },
  { id: 'is', name: 'İş Bankası', logo: '/assets/images/banks/is.jpg' },
  { id: 'yapi-kredi', name: 'Yapı Kredi', logo: '/assets/images/banks/yapikredi.webp' },
  { id: 'vakif', name: 'Vakıflar Bankası', logo: '/assets/images/banks/vakif.png' },
] as const

export const BANK_WITHDRAWAL_FEE = 0.05 // 5%
export const BANK_WITHDRAWAL_PROCESSING_TIME = '24 saat'
