'use client'

import React from 'react'
import { Icon as IconifyReact } from '@iconify/react'
import { cn } from '@/lib/utils'

export interface IconifyProps {
  /** Iconify icon adı (örn: "mdi:home", "solar:user-bold", "tabler:settings") */
  icon: string
  /** İkon boyutu - px cinsinden veya Tailwind size class */
  size?: number | 'xs' | 'sm' | 'md' | 'lg' | 'xl' | '2xl'
  /** İkon rengi - Tailwind color class veya CSS color */
  color?: string
  /** Ek CSS sınıfları */
  className?: string
  /** İkon tıklanabilir mi */
  clickable?: boolean
  /** Tıklama olayı */
  onClick?: () => void
  /** Inline style */
  style?: React.CSSProperties
}

// Boyut sınıfları ve px değerleri
const sizeMap = {
  xs: 12,
  sm: 16,
  md: 20,
  lg: 24,
  xl: 32,
  '2xl': 40
}


const Iconify: React.FC<IconifyProps> = ({
  icon,
  size = 'md',
  color = 'currentColor',
  className,
  clickable = false,
  onClick,
  style
}) => {
  // Boyut belirleme
  const iconSize = typeof size === 'number' ? size : sizeMap[size]

  // Color işleme - Tailwind class'ı mı yoksa CSS color mı?
  const colorValue = color.startsWith('text-') ? undefined : color
  const colorClass = color.startsWith('text-') ? color : undefined

  return (
    <span
      className={cn(
        'inline-flex items-center justify-center',
        colorClass,
        clickable && 'cursor-pointer hover:opacity-80 transition-opacity',
        className
      )}
      onClick={clickable ? onClick : undefined}
      style={style}
    >
      <IconifyReact
        icon={icon}
        width={iconSize}
        height={iconSize}
        color={colorValue}
      />
    </span>
  )
}

export { Iconify }
export default Iconify