'use client'
import React from 'react'
import { cn } from '@/lib/utils'
import Image from 'next/image'

export interface CardProps extends React.HTMLAttributes<HTMLDivElement> {
  variant?: 'default' | 'elevated' | 'bordered' | 'gradient' | 'gradient2'
  padding?: 'none' | 'sm' | 'md' | 'lg' | 'xl'
  hover?: boolean
  clickable?: boolean
  img?: string
  category?: 'green' | 'pink' | 'yellow' // Kategori için renk
}

export type CardContentProps = React.HTMLAttributes<HTMLDivElement>


const Card = React.forwardRef<HTMLDivElement, CardProps>(
  ({
    className,
    variant = 'default',
    padding = 'md',
    hover = false,
    clickable = false,
    img,
    category,
    children,
    ...props
  }, ref) => {
    const baseStyles = [
      'rounded-xl md:rounded-2xl  transition-all duration-200',
      'backdrop-blur-sm',
      'w-full line-clamp-3',
      'space-y-2'
    ]

    const variants = {
      default: [
        'bg-white/3 border border-base-3/50',
      ],
      elevated: [
        'bg-base-2/90 border border-base-3/30',
        'shadow-lg shadow-black/20',
      ],
      bordered: [
        'bg-base-1/50 border-2 border-base-3',
      ],
      gradient: [
        'bg-base-2',
        'border border-primary/20',
        'relative',
      ],
      gradient2: [
        'bg-base-2',
        'border border-primary/20',
        'relative',
      ],

    }

    const paddings = {
      none: '',
      sm: 'p-2 md:p-3',
      md: 'text-md font-medium p-2 md:p-3',
      lg: 'p-4 md:p-6',
      xl: 'p-6 md:p-8',
    }

    const interactions = {
      hover: hover ? 'hover:shadow-xl hover:shadow-black/25 hover:-translate-y-1' : '',
      clickable: clickable ? 'cursor-pointer hover:border-primary/30' : '',
    }

    return (
      <div
        className={cn(
          baseStyles,
          variants[variant],
          paddings[padding],
          interactions.hover,
          interactions.clickable,
          className,
        )}
        ref={ref}
        {...props}
      >
         { variant === 'gradient' && <div className='absolute w-2/3 -top-0 z-0 left-1/2 transition -translate-x-1/2 pointer-events-none'>
                      <svg className='absolute top-0 left-1/2 -translate-x-1/2' width="500"  height="46" viewBox="0 0 205 46" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M204.394 0C184.938 27.3762 146.607 46 102.5 46C58.3932 46 20.0623 27.3762 0.606445 0H204.394Z" fill="url(#paint0_radial_960_36017)" fillOpacity="0.35"/>
                      <defs>
                      <radialGradient id="paint0_radial_960_36017" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(101.582 -9) rotate(90) scale(55 99.569)">
                      <stop stopColor="#8570FF"/>
                      <stop offset="0.697115" stopColor="#8570FF" stopOpacity="0.2"/>
                      <stop offset="0.899038" stopColor="#8570FF" stopOpacity="0.05"/>
                      <stop offset="1" stopColor="#8570FF" stopOpacity="0"/>
                      </radialGradient>
                      </defs>
                      </svg>
                      <svg className=' absolute -top-2 left-1/2 -translate-x-1/2' height="48" viewBox="0 0 192 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                      <mask id="mask0_957_35191"  maskUnits="userSpaceOnUse" x="7" y="7" width="178" height="35">
                                      <mask id="path-1-inside-1_957_35191" fill="white">
                                      <path d="M96.0996 41.001C144.935 41.0009 184.523 29.5408 184.523 15.4043C184.523 12.4601 182.806 9.63268 179.646 7H12.5527C9.39251 9.63263 7.6748 12.4601 7.6748 15.4043C7.67508 29.5408 47.2642 41.001 96.0996 41.001Z"/>
                                      </mask>
                                      <path d="M96.0996 41.001C144.935 41.0009 184.523 29.5408 184.523 15.4043C184.523 12.4601 182.806 9.63268 179.646 7H12.5527C9.39251 9.63263 7.6748 12.4601 7.6748 15.4043C7.67508 29.5408 47.2642 41.001 96.0996 41.001Z" fill="#D9D9D9" fillOpacity="0.62"/>
                                      <path d="M96.0996 41.001L96.0996 41.501H96.0996V41.001ZM184.523 15.4043L185.023 15.4043L185.023 15.4043L184.523 15.4043ZM179.646 7V6.5H179.826L179.966 6.61583L179.646 7ZM12.5527 7L12.2327 6.61584L12.3718 6.5H12.5527V7ZM7.6748 15.4043L7.1748 15.4043V15.4043H7.6748ZM96.0996 41.001L96.0996 40.501C120.484 40.501 142.541 37.6392 158.486 33.0235C166.461 30.7147 172.879 27.9751 177.292 24.955C181.721 21.9238 184.023 18.6877 184.023 15.4043L184.523 15.4043L185.023 15.4043C185.023 19.1891 182.377 22.6867 177.857 25.7802C173.321 28.8848 166.789 31.6608 158.764 33.9841C142.705 38.6326 120.551 41.501 96.0996 41.501L96.0996 41.001ZM184.523 15.4043H184.023C184.023 12.67 182.429 9.96987 179.325 7.38417L179.646 7L179.966 6.61583C183.182 9.29549 185.023 12.2502 185.023 15.4043H184.523ZM179.646 7V7.5H12.5527V7V6.5H179.646V7ZM12.5527 7L12.8728 7.38416C9.76892 9.96983 8.1748 12.67 8.1748 15.4043H7.6748H7.1748C7.1748 12.2502 9.0161 9.29544 12.2327 6.61584L12.5527 7ZM7.6748 15.4043L8.1748 15.4043C8.17487 18.6877 10.4772 21.9239 14.9062 24.955C19.319 27.9751 25.7372 30.7147 33.7131 33.0236C49.6581 37.6393 71.7153 40.501 96.0996 40.501V41.001V41.501C71.6486 41.501 49.4934 38.6326 33.435 33.9841C25.4092 31.6608 18.8778 28.8849 14.3414 25.7802C9.82128 22.6867 7.17488 19.1891 7.1748 15.4043L7.6748 15.4043Z" fill="#8570FF" fillOpacity="0.45" mask="url(#path-1-inside-1_957_35191)"/>
                                      </mask>
                                      <g mask="url(#mask0_957_35191)">
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 353.064 8.74829)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 344.006 14.925)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 81.1401 -137.917)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 334.949 21.0999)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 94.5203 -131.229)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 325.892 27.2766)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 107.9 -124.537)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 316.835 33.4507)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 121.281 -117.847)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 307.776 39.6284)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 134.661 -111.158)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 298.719 45.8035)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 148.04 -104.468)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 289.663 51.9778)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 161.42 -97.7771)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 280.605 58.1531)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 174.802 -91.0881)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 271.548 64.3308)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 188.181 -84.397)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 262.49 70.5051)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 201.56 -77.7061)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 253.432 76.6802)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 214.942 -71.0173)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 244.375 82.8567)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 228.321 -64.3259)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 235.317 89.032)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 241.702 -57.636)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 226.26 95.2075)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 255.082 -50.947)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 217.203 101.383)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 268.461 -44.2571)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 208.145 107.56)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 281.842 -37.5659)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 199.088 113.734)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 295.221 -30.877)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 190.03 119.91)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 308.601 -24.1858)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 180.972 126.086)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 321.982 -17.4956)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 171.915 132.261)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 335.362 -10.8071)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 162.858 138.437)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 348.742 -4.11694)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 153.801 144.612)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="263.099" y2="-0.25" transform="matrix(-0.826225 0.56334 -0.894426 -0.447217 362.122 2.573)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      <line y1="-0.25" x2="359.025" y2="-0.25" transform="matrix(-0.894426 -0.447217 0.826225 -0.56334 144.742 150.787)" stroke="#8570FF" strokeOpacity="0.45" strokeWidth="0.5"/>
                                      </g>
                      </svg>
                      

                      <svg viewBox=" 0 0 153 1" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <rect width="153" height="1" fill="url(#paint0_radial_960_36014)"/>
                    <defs>
                    <radialGradient id="paint0_radial_960_36014" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(75.8109) rotate(90) scale(74.5 74.5)">
                    <stop stopColor="#8570FF"/>
                    <stop offset="0.697115" stopColor="#8570FF" stopOpacity="0.2"/>
                    <stop offset="0.899038" stopColor="#8570FF" stopOpacity="0.05"/>
                    <stop offset="1" stopColor="#8570FF" stopOpacity="0"/>
                    </radialGradient>
                    </defs>
                    </svg>
         </div> }
         
         {variant === 'default' && (
            <div className={cn(
              "absolute left-1/2 -top-0.5 transform -translate-x-1/2 h-1 w-12 md:w-24 rounded-full",
              category === 'green' && "bg-[#46B98B]",
              category === 'pink' && "bg-[#C77DFF]",
              category === 'yellow' && "bg-[#FFD60A]",
              !category && "bg-gray-500" // Default yeşil renk
            )}></div>
         )}

          { variant === 'gradient2' && (
            <>
             
              {/* Blur efekti */}
              <div className='absolute inset-0 blur-2xl opacity-40'>
                <span className='absolute z-0 -left-5  -top-15 w-36 h-36 bg-[#46B98B] rounded-full '/>
                <span className='absolute  z-0 -right-5  w-36 h-36  bg-[#8570FF] -bottom-20 rounded-full '/>
              </div>
            </>
          )}



        {img && (
            <Image
              src={img}
              width={400}
              height={400}
              alt="Card Image"
              unoptimized
              quality={100}
              className='rounded-xl md:rounded-xl w-full aspect-[4/4] relative z-10 left-0 top-0 object-cover'
              />
          )}
          
        {children}
      </div>
    )
  }
)


const CardContent = React.forwardRef<HTMLDivElement, CardContentProps>(
  ({ className, children, ...props }, ref) => {
    return (
      <div
        className={cn('pt-0', className)}
        ref={ref}
        {...props}
      >
        {children}
      </div>
    )
  }
)


Card.displayName = 'Card'
CardContent.displayName = 'CardContent'


export { Card, CardContent }
export default Card