'use client'

export default function TermsPage() {
  return (
    <div className="min-h-screen w-full  px-4 py-20">
      <div className="max-w-4xl mx-auto">
        {/* Header */}
        <div className="mb-8">
          <h1 className="text-white text-3xl lg:text-4xl font-bold mb-3">
            Kiqro - Müzik Dinle Kazan Uygulaması Kullanım Şartları
          </h1>
          <p className="text-gray-400 text-sm italic">
            Last reviewed on [18.03.2024]
          </p>
        </div>

        {/* Content */}
        <div className="prose prose-invert max-w-none">
          {/* 1. Genel Hükümler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">1. Genel Hükümler</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash uygulamasını kullanarak, bu Kullanım Şartları&apos;nı kabul etmiş sayılırsınız. Bu sözleşme, uygulamamızın kullanımına ilişkin kuralları, kullanıcı sorumluluklarını ve haklarını belirler.
            </p>
            <p className="text-gray-300 leading-relaxed">
              Şartları kabul etmiyorsanız, lütfen uygulamayı kullanmayınız.
            </p>
          </section>

          {/* 2. Hesap Oluşturma ve Kullanıcı Sorumlulukları */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">2. Hesap Oluşturma ve Kullanıcı Sorumlulukları</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Uygulamayı kullanmak için bir hesap oluşturmanız gerekmektedir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>18 yaşından büyük olmanız veya yasal veli onayına sahip olmanız zorunludur.</li>
              <li>Kayıt sırasında doğru, güncel ve eksiksiz bilgi vermelisiniz.</li>
              <li>Hesap güvenliğinizden siz sorumlusunuz. Şifrenizi kimseyle paylaşmayınız.</li>
              <li>Bir kişi yalnızca bir hesap oluşturabilir. Çoklu hesap kullanımı yasaktır.</li>
              <li>Hesabınızda yetkisiz bir etkinlik fark ederseniz, derhal bizimle iletişime geçiniz.</li>
            </ul>
          </section>

          {/* 3. Hizmetin Kullanımı */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">3. Hizmetin Kullanımı</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash, kullanıcıların müzik dinleyerek ödül kazanmasını sağlar:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Müzikleri dinleyerek puan kazanabilir ve bu puanları nakde çevirebilirsiniz.</li>
              <li>Görevleri tamamlayarak ekstra ödüller kazanabilirsiniz.</li>
              <li>Referans sistemi ile arkadaşlarınızı davet ederek komisyon elde edebilirsiniz.</li>
              <li>Kazançlarınız hesabınıza tanımlı ödeme yöntemleriyle çekilebilir.</li>
            </ul>
          </section>

          {/* 4. Yasak Faaliyetler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">4. Yasak Faaliyetler</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Aşağıdaki faaliyetler kesinlikle yasaktır ve hesabınızın kalıcı olarak kapatılmasına yol açabilir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Botlar, otomatik yazılımlar veya manipülasyon araçları kullanmak,</li>
              <li>Sahte hesaplar oluşturmak veya birden fazla hesap kullanmak,</li>
              <li>Hile, dolandırıcılık veya sistemi kandırmaya yönelik girişimlerde bulunmak,</li>
              <li>Uygunsuz, yasadışı veya zararlı içerik paylaşmak,</li>
              <li>Diğer kullanıcıları taciz etmek veya spam göndermek,</li>
              <li>Uygulamanın altyapısına zarar vermek veya tersine mühendislik yapmak.</li>
            </ul>
          </section>

          {/* 5. Ödeme ve Para Çekme */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">5. Ödeme ve Para Çekme</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kazandığınız ödülleri aşağıdaki kurallara göre çekebilirsiniz:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Minimum çekim tutarı <strong className="text-white">50 TL</strong>&apos;dir.</li>
              <li>Ödeme talepleri 24-48 saat içinde işleme alınır.</li>
              <li>Çekim yöntemleri: Papara, Banka Havalesi/EFT, USDC (kripto).</li>
              <li>Çekim işlemleri yalnızca hesap sahibinin kendi adına kayıtlı hesaplara yapılabilir.</li>
              <li>Şüpheli işlemler tespit edilirse, ödemeniz askıya alınabilir veya iptal edilebilir.</li>
            </ul>
          </section>

          {/* 6. Fikri Mülkiyet Hakları */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">6. Fikri Mülkiyet Hakları</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash uygulaması, logosu, tasarımı ve içerikleri Kiqro Cash&apos;in fikri mülkiyetidir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Uygulama içeriğini izinsiz kopyalayamaz, dağıtamaz veya ticari amaçla kullanamazsınız.</li>
              <li>Müzikler ve içerikler, ilgili telif hakkı sahiplerinin lisansları altında sunulmaktadır.</li>
              <li>Kullanıcılar, yükledikleri içeriklerin telif haklarına saygı göstermekle yükümlüdür.</li>
            </ul>
          </section>

          {/* 7. Hizmet Kesintileri ve Değişiklikler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">7. Hizmet Kesintileri ve Değişiklikler</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash, hizmeti iyileştirmek veya teknik nedenlerle kesinti yapma hakkını saklı tutar:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Planlı bakımlar önceden duyurulacaktır.</li>
              <li>Acil durumlarda hizmet geçici olarak durdurulabilir.</li>
              <li>Uygulama özellikleri, ödül sistemi veya kullanıcı arayüzü değiştirilebilir.</li>
            </ul>
          </section>

          {/* 8. Sorumluluk Reddi */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">8. Sorumluluk Reddi</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash, aşağıdaki durumlardan sorumlu tutulamaz:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>İnternet bağlantısı veya cihaz kaynaklı sorunlar,</li>
              <li>Üçüncü taraf hizmet sağlayıcıların (ödeme sistemleri, müzik platformları) hataları,</li>
              <li>Kullanıcı hesaplarının yetkisiz erişime maruz kalması (kullanıcı kusuru varsa),</li>
              <li>Uygulama üzerinden erişilen harici bağlantıların içeriği.</li>
            </ul>
          </section>

          {/* 9. Hesap Askıya Alma ve Sonlandırma */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">9. Hesap Askıya Alma ve Sonlandırma</h2>
            <p className="text-gray-300 leading-relaxed mb-4">
              Kiqro Cash, aşağıdaki durumlarda hesapları askıya alabilir veya sonlandırabilir:
            </p>
            <ul className="list-disc list-inside text-gray-300 space-y-2 ml-4">
              <li>Kullanım Şartları&apos;nın ihlal edilmesi,</li>
              <li>Dolandırıcılık veya şüpheli aktivite tespiti,</li>
              <li>Kullanıcı talebi üzerine hesap kapatma,</li>
              <li>Uzun süreli inaktiflik (1 yıl ve üzeri).</li>
            </ul>
          </section>

          {/* 10. Uyuşmazlık Çözümü */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">10. Uyuşmazlık Çözümü</h2>
            <p className="text-gray-300 leading-relaxed">
              Bu sözleşmeden doğan uyuşmazlıklar, öncelikle dostane görüşmelerle çözülmeye çalışılacaktır. Çözüm sağlanamazsa, İstanbul (Çağlayan) Mahkemeleri ve İcra Daireleri yetkilidir.
            </p>
          </section>

          {/* 11. Değişiklikler ve Güncellemeler */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">11. Değişiklikler ve Güncellemeler</h2>
            <p className="text-gray-300 leading-relaxed">
              Kiqro Cash, Kullanım Şartları&apos;nı istediği zaman güncelleme hakkını saklı tutar. Önemli değişiklikler uygulama içi bildirimlerle duyurulacaktır. Güncellemelerden sonra uygulamayı kullanmaya devam etmeniz, yeni şartları kabul ettiğiniz anlamına gelir.
            </p>
          </section>

          {/* 12. İletişim */}
          <section className="mb-8">
            <h2 className="text-white text-2xl font-bold mb-4">12. İletişim</h2>
            <p className="text-gray-300 leading-relaxed mb-2">
              Kullanım şartları ile ilgili sorularınız için:
            </p>
            <p className="text-gray-300 leading-relaxed">
              <strong className="text-white">E-posta:</strong> <span className="text-primary">destek@kiqro.com</span><br />
              <strong className="text-white">Adres:</strong> Kiqro Cash, İstanbul, Türkiye<br />
              <strong className="text-white">Telefon:</strong> +90 (212) 555 00 00
            </p>
          </section>

          {/* Son Not */}
          <section className="mb-8 bg-base-2 rounded-2xl p-6">
            <p className="text-gray-300 leading-relaxed">
              <strong className="text-white">Önemli Not:</strong> Bu Kullanım Şartları, Kiqro Cash ve kullanıcıları arasındaki yasal sözleşmeyi oluşturur. Lütfen dikkatlice okuyunuz ve anladığınızdan emin olunuz. Sorularınız varsa, bizimle iletişime geçmekten çekinmeyiniz.
            </p>
          </section>
        </div>
      </div>
    </div>
  );
}
