'use client'
import { useState } from 'react'
import { Footer } from '@/components/layout'
import { AdditionalInfoModal, SocialAdditionalInfoModal } from '@/components/sections'
import Image from 'next/image'
import { HeroSection, SignupSection, TaskSetupSection, LivePaymentSection, FeatureSection, FAQSection } from './_components'

export default function Home() {
  const [showAdditionalInfoModal, setShowAdditionalInfoModal] = useState(false)
  const [showSocialInfoModal, setShowSocialInfoModal] = useState(false)
  const [socialProvider, setSocialProvider] = useState<'google' | 'apple' | 'facebook' | undefined>(undefined)
  const [signupData, setSignupData] = useState<{
    firstName: string
    lastName: string
    password: string
  } | undefined>(undefined)

  const handleFormSubmit = (firstName: string, lastName: string, password: string) => {
    setSignupData({ firstName, lastName, password })
    setShowAdditionalInfoModal(true)
  }

  const handleSocialSignup = (provider: 'google' | 'apple' | 'facebook') => {
    setSocialProvider(provider)
    setShowSocialInfoModal(true)
  }

  return (
    <div  className="pt-16 relative flex flex-col items-center  min-h-screen w-full bg-background text-white overflow-y-auto scrollbar-hide">
      
      <span className='absolute z-0 -top-40 md:-top-80'>
        <Image
        src={"./assets/images/bg_light.png"}
          alt="Background Light"
          width={1920}
          height={1080}
          objectFit="contain"
          quality={100}
          unoptimized
          className='w-full h-auto'
        />
      </span>
      <main className="container pt-12 md:pt-24 relative z-10 mx-auto items-center flex flex-col px-4 md:px-6 lg:px-4 py-6 md:py-12">
        {/* Hero Section */}
        <HeroSection
          onCardClick={(appName, size) => console.log(`${appName} ${size} görevine tıklandı!`)}
        />
      {/* 2. Section  Start */}
      <SignupSection
        onFormSubmit={handleFormSubmit}
        onGoogleSignup={() => handleSocialSignup('google')}
        onAppleSignup={() => handleSocialSignup('apple')}
        onFacebookSignup={() => handleSocialSignup('facebook')}
      />
      {/* 2. Section  End */}

      {/* 3. Section  Start */}
      <TaskSetupSection/>

      <TaskSetupSection
      title='Dakikalar İçinde '
      subtitle='Para Kazan!'
      description='Görevlerin çoğu son derece kolay ve hali hazırda binlerce kişiye kazanç sağlamış. Çoğu görev sadece 5-10 dakikanızı alıyor, hızlıca tamamlayıp para kazanabilirsiniz.'
      imageSrc='/assets/images/görevini-başlat.png'
      imageAlt='Görevini Başlat'
      stepNumber='2'
      stepTitle='2. Görevini Tamamla'
      />
      
      <TaskSetupSection
      title='Kolayca Kazan,'
      subtitle='Hemen Harca!'
      description='Her tamamladığın görev sana coin kazandırır: 1000 coin = 1,00 $. Biriktirdiğin coinleri kolayca nakde çevirip ücretsiz paranı alabilirsin!'
      imageSrc='/assets/images/paranı-al.png'
      imageAlt='Paranı Al'
      stepNumber='3'
      stepTitle='3. Paranı Al'
      />
      {/* 3. Section  End */}
      {/* 4. Section  Start */}
      <LivePaymentSection />
      {/* 4. Section  End */}

      {/* 5. Section Start */}
      <FeatureSection />
      {/* 5. Section End */}
      {/* 6. Section Start */}
      <FAQSection />
      {/* 6. Section End */}


      </main>
  <div className='container'>
        <Footer />
      </div>

      {/* Additional Info Modal */}
      <AdditionalInfoModal
        isOpen={showAdditionalInfoModal}
        onClose={() => setShowAdditionalInfoModal(false)}
        initialData={signupData}
      />

      {/* Social Additional Info Modal - E-posta olmadan */}
      <SocialAdditionalInfoModal
        isOpen={showSocialInfoModal}
        onClose={() => setShowSocialInfoModal(false)}
        provider={socialProvider}
      />
    </div>
  )
}