'use client'

import { useState } from "react";
import { Button, Input, Iconify } from "@/components/ui";

export default function ContactPage() {
  const [formData, setFormData] = useState({
    email: '',
    subject: '',
    message: ''
  });

  const handleSubmit = () => {
    console.log('Contact form submitted:', formData);
    // API çağrısı yapılacak
  };

  return (
    <div className="min-h-screen w-full bg-base-1 flex items-center justify-center px-4 py-20">
      <div className="w-full max-w-2xl">
        {/* Header */}
        <div className="flex items-center justify-start gap-3 mb-8">
          <div className="w-12 h-12 bg-primary/10 rounded-xl flex items-center justify-center">
            <Iconify icon="mdi:email-outline" size={28} className="text-primary" />
          </div>
          <h1 className="text-white text-2xl lg:text-2xl font-semibold">İletişim Formu</h1>
        </div>

        {/* Form Card */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <div className="space-y-6">
            {/* E-Posta Adresiniz */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">
                E-Posta Adresiniz
              </label>
              <Input
                type="email"
                placeholder="example@site.com"
                value={formData.email}
                onChange={(e) => setFormData({ ...formData, email: e.target.value })}
                containerClassName="w-full"
              />
            </div>

            {/* Konu */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">
                Konu
              </label>
              <Input
                type="text"
                placeholder="Konu Nedir"
                value={formData.subject}
                onChange={(e) => setFormData({ ...formData, subject: e.target.value })}
                containerClassName="w-full"
              />
            </div>

            {/* Mesajınız */}
            <div>
              <label className="block text-white text-sm font-medium mb-2">
                Mesajınız
              </label>
              <textarea
                placeholder="Mesajınız"
                value={formData.message}
                onChange={(e) => setFormData({ ...formData, message: e.target.value })}
                rows={6}
                className="w-full bg-base-3 text-white px-4 py-3 rounded-xl border border-white/5 focus:border-primary/50 focus:outline-none transition-colors resize-none placeholder:text-gray-500"
              />
            </div>

            {/* Gönder Butonu */}
            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={handleSubmit}
              className="mt-4"
            >
              Gönder
            </Button>
          </div>
        </div>
      </div>
    </div>
  );
}
