import React from 'react'
import { Icon } from '@/components/ui'
import Image from 'next/image'

interface TaskSetupSectionProps {
  title?: string
  subtitle?: string
  description?: string
  imageSrc?: string
  imageAlt?: string
  stepNumber?: string
  stepTitle?: string
  className?: string
}

export function TaskSetupSection({
  title = "Seç, dene, kazan",
  subtitle = "- bu kadar basit!",
  description = "Mear Cash kazanç panelinde sana özel hazırlanan görevler arasından dilediğini seç. Uygulamalarını, anketlerini ve ürünlerini tanıtmak isteyen markaların en kazançlı tekliflerini senin için listeliyoruz.",
  imageSrc = "/assets/images/görevini_belirle.png",
  imageAlt = "Görevini Belirle",
  stepNumber = "1",
  stepTitle = "1.Görevini Belirle",
  className = ""
}: TaskSetupSectionProps) {
  return (
    <section className={`w-full pt-5 md:pt-0 px-4 ${className}`}>
      <div className="w-full flex flex-col md:flex-row items-start md:space-x-12 lg:space-x-24 justify-center">
        {/* Sol Taraf - Adım Göstergesi */}
        <div className="flex md:flex-col flex-row md:space-y-2 space-x-4 md:space-x-0 items-center md:items-center justify-start mb-6 md:mb-0"> 
          {/* İkon Container */}
          <div className="p-[1px] w-fit h-fit bg-gradient-to-b from-[#6F629B] to-transparent rounded-[13px]">
            <div className="flex justify-center items-center w-12 h-12 md:w-14 md:h-14 bg-base-3 rounded-xl">
              <Icon name="lucide:mouse-pointer-click" size="lg" className="md:text-xl" />
            </div>
          </div>
          
          {/* Adım Başlığı */}
          <div className="text-center text-sm md:text-base font-medium">{stepTitle}</div>
          
          {/* Dikey Çizgi - Sadece desktop'ta görünür */}
          <span className="hidden md:block text-sm text-white/50">
            <svg width="1" height="480" viewBox="0 0 1 480" fill="none" xmlns="http://www.w3.org/2000/svg" className="md:h-[280px] lg:h-[480px]">
              <line 
                x1="0.5" 
                y1="2.37319e-08" 
                x2="0.499977" 
                y2="100%" 
                stroke="#444054" 
                strokeDasharray="10 10"
              />
            </svg>
          </span>
        </div>

        {/* Sağ Taraf - İçerik */}
        <div className="w-full md:w-[55%]"> 
          {/* Başlık */}
          <h2 className="text-xl md:text-2xl font-medium">
            {title} <span className="text-[#BDB2FF]">{subtitle}</span>
          </h2>
          
          {/* Açıklama */}
          <p className="text-white/50 text-sm md:text-base mt-2 mb-4 md:mb-6 leading-relaxed">
            {description}
          </p>
          
          {/* Görsel */}
          <div className="relative">
            <Image
              src={imageSrc}
              alt={imageAlt}
              width={1000}
              height={1000}
              unoptimized
              quality={100}
              className="rounded-2xl md:rounded-4xl w-full md:w-[670px] h-auto md:h-[320px] border-1 border-primary/20 object-cover transition-transform duration-300 hover:scale-105"
            />
            
            </div>
        </div>
      </div>
    </section>
  )
}