'use client'

import { useState } from "react";
import { useRouter } from "next/navigation";
import { Button, Input, Icon, Modal } from "@/components/ui";
import { StatCard } from "../../_components";

export default function PaparaWithdrawPage() {
  const router = useRouter();
  const [balance] = useState<string>("23.540₺");
  const [showVerificationModal, setShowVerificationModal] = useState(false);
  const [formData, setFormData] = useState({
    paparaNumber: '',
    amount: '',
    phoneNumber: ''
  });

  const handleAmountChange = (value: string) => {
    // Sadece sayı ve nokta kabul et
    const numericValue = value.replace(/[^0-9.]/g, '');
    setFormData({ ...formData, amount: numericValue });
  };

  const handleUseAllBalance = () => {
    // Bakiyedeki ₺ ve virgülü temizle
    const numericBalance = balance.replace(/[₺,]/g, '').replace(',', '.');
    setFormData({ ...formData, amount: numericBalance });
  };

  const handleSubmit = () => {
    console.log('Form submitted:', formData);
    // Form gönderme işlemi - modal aç
    setShowVerificationModal(true);
  };

  const handleModalClose = () => {
    setShowVerificationModal(false);
  };

  const handleGoToSettings = () => {
    setShowVerificationModal(false);
    router.push('/settings');
  };

  const handleBack = () => {
    router.back();
  };

  return (
    <div className="min-h-screen w-full mt-14 bg-base-1 p-4 lg:p-6">
      {/* Header */}
      <div className="w-full mx-auto mb-6">
        <button
          onClick={handleBack}
          className="flex items-center gap-2 text-gray-400 hover:text-white transition-colors mb-4"
        >
    
        </button>

        <div className="flex items-center gap-4">
          <div className="w-16 h-16 bg-base-2 rounded-2xl flex items-center justify-center">
            <Icon name="papara" size={32} className="text-white" />
          </div>
          <div>
            <h1 className="text-2xl font-bold text-white mb-1">Papara ile Çekim</h1>
            <p className="text-gray-400 text-sm">Ücretsiz Çekim</p>
          </div>
        </div>
      </div>
      <div className="w-full border-b border-white/10 mb-6" />

      {/* Çekilebilir Bakiye Kartı */}
      <div className="bg-base-2 rounded-3xl p-6 mb-6">
        <div className="flex items-center gap-3 mb-2">
          <Icon name="si:money-fill" size={24}/>
          <span className="text-gray-400 text-sm">Çekilebilir Bakiye</span>
        </div>
        <h2 className="text-4xl font-bold text-primary mb-4">{balance}</h2>
      </div>

      {/* Main Content */}
      <div className="w-full mx-auto grid grid-cols-1 lg:grid-cols-2 gap-6">
        {/* Sol Taraf - Form */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <h2 className="text-xl font-semibold text-white mb-6">İşlem</h2>

          <div className="space-y-5">
            {/* Papara Numaranız */}
            <Input
              label="Papara Numaranız"
              type="text"
              placeholder="İsim"
              value={formData.paparaNumber}
              onChange={(e) => setFormData({ ...formData, paparaNumber: e.target.value })}
              containerClassName="w-full"
            />

            {/* Tutar Giriniz */}
            <div className="relative">
              <Input
                label="Tutar Giriniz"
                type="text"
                placeholder="Tutar"
                value={formData.amount}
                onChange={(e) => handleAmountChange(e.target.value)}
                containerClassName="w-full"
              />
              <button
                type="button"
                onClick={handleUseAllBalance}
                className="absolute right-0 top-1 underline text-xs text-primary hover:text-primary/80 transition-colors font-medium"
              >
                Tüm Bakiye
              </button>
            </div>

            {/* Telefon Numarası */}
            <Input
              label="Telefon Numarası"
              type="tel"
              placeholder="Telefon Numarası"
              value={formData.phoneNumber}
              onChange={(e) => setFormData({ ...formData, phoneNumber: e.target.value })}
              containerClassName="w-full"
            />

            {/* Gönder Butonu */}
            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={handleSubmit}
              className="mt-6"
            >
              Gönder
            </Button>
          </div>
        </div>

        {/* Sağ Taraf - Bilgilendirme */}
        <div className="bg-base-2 rounded-3xl p-6 lg:p-8">
          <h2 className="text-lg font-semibold text-orange-400 mb-4">
            Papara Çekim Talepleri Hakkında Önemli Bilgilendirme
          </h2>

          <div className="space-y-4 text-gray-300 text-sm leading-relaxed">
            <p>
              Papara üzerinden gerçekleştireceğiniz çekim taleplerinizde, işlemlerin yalnızca kendi açınıza kayıtlı banka hesap numaranıza ve yine kendi adınıza tanımlı telefon numaranızı üzerinden yapılması gerekmektedir. Bu durum, güvenliğinizin korunması ve işlemlerinizin herhangi bir aksaklık olmadan tamamlanabilmesi için zorunludur.
            </p>

            <p>
              Çekim taleplerinin işleme alınması, yoğunluğa bağlı olarak 24 saat içerisinde sonuçlandırılmaktadır. İşlemlerinizin geçerliliği sırasında farklı bir hesap ya da numara kullanılması halinde sistem tarafından otomatik olarak reddedilecek ve tarafınıza kayıtlı e-posta adresinize bilgilendirme gönderilecektir. Bu nedenle, sürecin sorunsuz bir şekilde ilerlemesi için talep oluştururken bilgilerinizin güncel ve doğru olduğundan emin olmanız son derece önemlidir.
            </p>
          </div>
        </div>
      </div>

      {/* Verification Modal */}
      <Modal isOpen={showVerificationModal} onClose={handleModalClose}>
        <div className="p-6 text-center space-y-6">
          {/* Warning Icon */}
          <div className="flex justify-center">
            <StatCard
              icon="material-symbols:warning-outline"
              size="lg"
              color="default"
              iconColor="text-yellow-500"
            />
          </div>

          <div className="space-y-2">
            <p className="text-sm text-white/70">
              E-posta veya telefon doğrulaması yapmanız gerekiyor.
            </p>
          </div>
          
          <Button 
            variant="primary" 
            size="md" 
            fullWidth 
            onClick={handleGoToSettings}
          >
            Ayarlara Git
          </Button>
        </div>
      </Modal>
    </div>
  );
}
