
'use client'
import { useState } from "react";
import { useRouter } from "next/navigation";
import { Button, Icon, Iconify, Modal } from "@/components/ui";
import { Footer } from "@/components/layout";
import Image from "next/image";
import { IconName } from "@/lib/icons";
import { StatCard } from "../_components";

interface WithdrawMethod {
  id: string;
  icon: IconName;
  title: string;
  subtitle: string;
  badge?: string;
}

interface StoreProduct {
  id: string;
  image: string;
  title: string;
  description: string;
  price: string;
}


export default function WalletPage() {
  const router = useRouter();
  const [balance] = useState<string>("23.540₺");

  // Modal state for digital store
  const [selectedProduct, setSelectedProduct] = useState<StoreProduct | null>(null);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [isConfirmed, setIsConfirmed] = useState(false);

  const handleWithdrawClick = (methodId: string) => {
    if (methodId === 'papara') {
      router.push('/wallet/papara');
    } else if (methodId === 'bank') {
      router.push('/wallet/bank');
    } else if (methodId === 'usdc') {
      router.push('/wallet/usdc');
    }
  };

  // Digital store card click handler
  const handleProductClick = (product: StoreProduct) => {
    setSelectedProduct(product);
    setIsModalOpen(true);
    setIsConfirmed(false);
  };

  const handleModalConfirm = () => {
    setIsConfirmed(true);
    // Sipariş onaylandı işlemleri burada yapılabilir
  };

  const handleModalCancel = () => {
    setIsModalOpen(false);
    setSelectedProduct(null);
    setIsConfirmed(false);
  };

  // Para çekim yöntemleri
  const withdrawMethods: WithdrawMethod[] = [
    {
      id: "papara",
      icon: 'papara',
      title: "Papara ile Çekim",
      subtitle: "Ücretsiz Çekim",
      badge: "Hızlı"
    },
    {
      id: "bank",
      icon: 'mdi:bank-outline',
      title: "Havale / Eft",
      subtitle: "%5 Çekim komisyonu"
    },
    {
      id: "usdc",
      icon: 'token-branded:usdt',
      title: "USDC Çekim",
      subtitle: "Kripto USDC ile Çekim",
      badge: "Hızlı"
    }
  ];

  // Dijital mağaza ürünleri
  const storeProducts: StoreProduct[] = [
    {
      id: "1",
      image: "/assets/images/digital_magaza_görselleri/trendyol.jpg",
      title: "Trendyol",
      description: "Çekim yapacağınız tutarın %10 daha fazlasını Trendyol'da harcayın!",
      price: "200₺"
    },
    {
      id: "2",
      image: "/assets/images/digital_magaza_görselleri/amazon.png",
      title: "Trendyol",
      description: "Çekim yapacağınız tutarın %10 daha fazlasını Trendyol'da harcayın!",
      price: "200₺"
    },
    {
      id: "3",
      image: "/assets/images/digital_magaza_görselleri/lcw.png",
      title: "Trendyol",
      description: "Çekim yapacağınız tutarın %10 daha fazlasını Trendyol'da harcayın!",
      price: "200₺"
    },
    {
      id: "4",
      image: "/assets/images/digital_magaza_görselleri/amazon.png",
      title: "Trendyol",
      description: "Çekim yapacağınız tutarın %10 daha fazlasını Trendyol'da harcayın!",
      price: "200₺"
    },
    {
      id: "5",
      image: "/assets/images/digital_magaza_görselleri/lcw.png",
      title: "Trendyol",
      description: "Çekim yapacağınız tutarın %10 daha fazlasını Trendyol'da harcayın!",
      price: "200₺"
    }
  ];

  return (
    <div className="pt-20 md:pt-0 md:h-screen overflow-y-auto w-full p-4 lg:pt-20 lg:p-6">
      {/* Başlık */}
      <h1 className="text-2xl font-bold text-white mb-6">Para Çekim İşlemleri</h1>

      {/* Çekilebilir Bakiye Kartı */}
      <div className="bg-base-2 rounded-3xl p-6 mb-6">
        <div className="flex items-center gap-3 mb-2">
          <Icon name="si:money-fill" size={24}/>
          <span className="text-gray-400 text-sm">Çekilebilir Bakiye</span>
        </div>
        <h2 className="text-4xl font-bold text-primary mb-4">{balance}</h2>
      </div>

      {/* Para Çekim Yöntemleri */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-4 mb-8">
        {withdrawMethods.map((method) => (
          <div
            key={method.id}
            onClick={() => handleWithdrawClick(method.id)}
            className="bg-base-2 flex justify-between rounded-2xl p-6 hover:bg-base-2/80 transition-all cursor-pointer group relative"
          >
            {method.badge && (
              <div className="absolute -top-4 left-2 bg-[#46B98B] px-4 rounded-full">
                <span className="text-xs font-medium">{method.badge}</span>
              </div>
            )}
            
            <div className="flex items-start gap-3">
              <div className="w-12 h-12 bg-base-3 rounded-xl flex items-center justify-center flex-shrink-0 ">
                <Icon name={method.icon} size={24} className="text-white" />
              </div>
              <div className="flex-1">
                <h3 className="text-white font-semibold text-lg mb-1 transition-colors">
                  {method.title}
                </h3>
                <p className="text-gray-400 text-sm">{method.subtitle}</p>
              </div>
            </div>

            <Iconify icon="weui:arrow-filled" size={20} />
          </div>
        ))}
      </div>


      {/* Dijital Mağaza */}
      <div className="mb-6">
        <h2 className="text-xl md:text-2xl font-bold text-white mb-3 md:mb-4">Dijital Mağaza</h2>
        {/* Ürün Kartları Grid */}
        <div className="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-5 gap-2 md:gap-4">
          {storeProducts.map((product) => (
            <div
              key={product.id}
              className="bg-base-2 rounded-xl md:rounded-2xl overflow-hidden hover:bg-base-2/80 transition-all cursor-pointer group"
              onClick={() => handleProductClick(product)}
            >
              {/* Ürün Görseli */}
              <div className="relative w-full aspect-square bg-gradient-to-br from-base-3 to-base-2 p-2 md:p-4">
                <div className="relative w-full h-full rounded-md overflow-hidden">
                  <Image
                    src={product.image}
                    alt={product.title}
                    fill
                    className="object-cover"
                  />
                </div>
              </div>

              {/* Ürün Bilgileri */}
              <div className="p-2 md:p-4">
                <h3 className="text-white font-semibold text-xs md:text-base lg:text-lg mb-1 md:mb-2 line-clamp-1">
                  {product.title}
                </h3>
                <p className="text-gray-400 text-[10px] md:text-xs lg:text-sm mb-2 md:mb-4 line-clamp-2">
                  {product.description}
                </p>
                {/* Fiyat ve Buton */}
                <Button 
                  variant="outline" 
                  size="sm"
                  fullWidth
                   >
                  <span className="font-semibold">{product.price} Kullan</span>
                </Button>
              </div>
            </div>
          ))}
        </div>

        {/* Sipariş Onay Modalı */}
        <Modal isOpen={isModalOpen} onClose={handleModalCancel}>
          <div className="p-6 text-center">
            {isConfirmed ? (
              <div className="space-y-4">
                {/* Success Card */}
                <div className="flex justify-center mb-4">
                  <StatCard
                    icon="ep:success-filled"
                    size="lg"
                    color="default"
                     iconColor="text-yellow-500"
                  />
                </div>

                <h3 className="text-lg font-medium text-white">Siparişiniz Onaylandı!</h3>
                <p className="text-sm text-white/50">Mail adresinize bildirim düşecektir</p>
                
                <Button variant="primary" size="md" fullWidth onClick={handleModalCancel}>
                  Kapat
                </Button>
              </div>
            ) : (
              <>
                <h3 className="text-lg font-bold text-white mb-4">Siparişinizi onaylıyor musunuz?</h3>
                {selectedProduct && (
                  <div className="mb-4">
                    <Image
                      src={selectedProduct.image}
                      alt={selectedProduct.title}
                      width={120}
                      height={120}
                      className="mx-auto rounded-xl"
                    />
                    <p className="text-white font-semibold text-xl mt-2">{selectedProduct.title}</p>
                    <p className="text-gray-400 text-md mt-1">{selectedProduct.price}</p>
                  </div>
                )}
                <div className="flex justify-center gap-4 mt-6">
                  <Button variant="primary" size="md" onClick={handleModalConfirm}>
                    Evet
                  </Button>
                  <Button variant="outline" size="md" onClick={handleModalCancel}>
                    Hayır
                  </Button>
                </div>
              </>
            )}
          </div>
        </Modal>
      </div>
      
      <Footer />
    </div>
  );
}
