'use client'

import { useState } from "react";
import { Iconify, Button, ToggleSwitch, Input, Modal } from "@/components/ui";
import { Footer } from "@/components/layout";
import Image from "next/image";

export default function SettingsPage() {
  // E-posta doğrulama state
  const [isEmailVerified, setIsEmailVerified] = useState(false);
  const [showEmailVerificationModal, setShowEmailVerificationModal] = useState(false);
  const [emailVerificationCode, setEmailVerificationCode] = useState('');
  const [isEditingEmail, setIsEditingEmail] = useState(false);
  const [tempEmail, setTempEmail] = useState('');
  
  // Telefon doğrulama state
  const [isPhoneVerified, setIsPhoneVerified] = useState(false);
  const [showPhoneVerificationModal, setShowPhoneVerificationModal] = useState(false);
  const [phoneVerificationCode, setPhoneVerificationCode] = useState('');
  const [isEditingPhone, setIsEditingPhone] = useState(false);
  const [tempPhone, setTempPhone] = useState('');
  
  // Ortak state
  const [isLoading, setIsLoading] = useState(false);
  const [error, setError] = useState('');

  // Kullanıcı bilgileri state
  const [userInfo, setUserInfo] = useState({
    name: 'Arda Kılıç',
    username: 'ardakllc',
    email: 'aileinizi106@gmail.com',
    phone: '+90 xxx xxxx xx',
    referralCode: '-',
    joinDate: '12.03.2024'
  });

  // Ayarlar state
  const [settings, setSettings] = useState({
    language: 'Türkçe',
    notifications: {
      everyone: true,
      onlyFollowers: true,
      liveShow: true,
      mailNotifications: true,
      smsNotifications: true,
      twoFactorAuth: true
    }
  });

  // Şifre değiştirme state
  const [passwordForm, setPasswordForm] = useState({
    currentPassword: '',
    newPassword: '',
    confirmPassword: ''
  });

  const handlePasswordChange = () => {
    console.log('Password change:', passwordForm);
    // API çağrısı yapılacak
  };

  const handleToggle = (key: string) => {
    setSettings(prev => ({
      ...prev,
      notifications: {
        ...prev.notifications,
        [key]: !prev.notifications[key as keyof typeof prev.notifications]
      }
    }));
  };

  const handleAccountDelete = () => {
    console.log('Hesabı sil');
    // Onay modalı açılacak
  };

  // E-posta doğrulama fonksiyonları
  const handleSendEmailVerificationCode = async () => {
    setIsLoading(true);
    setError('');
    try {
      // Simulate API call
      console.log('Sending email verification code to:', userInfo.email);
      await new Promise(resolve => setTimeout(resolve, 1000));
      setShowEmailVerificationModal(true);
    } catch (err) {
      setError('Kod gönderilirken bir hata oluştu');
    } finally {
      setIsLoading(false);
    }
  };

  const handleVerifyEmailCode = async () => {
    if (!emailVerificationCode || emailVerificationCode.length !== 6) {
      setError('Lütfen 6 haneli kodu girin');
      return;
    }

    setIsLoading(true);
    setError('');
    try {
      // Simulate API call
      console.log('Verifying email code:', emailVerificationCode);
      await new Promise(resolve => setTimeout(resolve, 1000));
      
      setIsEmailVerified(true);
      setShowEmailVerificationModal(false);
      setEmailVerificationCode('');
      
      // Eğer email değiştirilmişse güncelle
      if (tempEmail) {
        setUserInfo(prev => ({ ...prev, email: tempEmail }));
        setTempEmail('');
        setIsEditingEmail(false);
      }
    } catch (err) {
      setError('Kod doğrulanamadı');
    } finally {
      setIsLoading(false);
    }
  };

  const handleEditEmail = () => {
    setIsEditingEmail(true);
    setTempEmail(userInfo.email);
  };

  const handleCancelEditEmail = () => {
    setIsEditingEmail(false);
    setTempEmail('');
  };

  const handleSaveEmail = () => {
    if (tempEmail && tempEmail !== userInfo.email) {
      setIsEmailVerified(false);
      handleSendEmailVerificationCode();
    }
  };

  // Telefon doğrulama fonksiyonları
  const handleSendPhoneVerificationCode = async () => {
    setIsLoading(true);
    setError('');
    try {
      // Simulate API call
      console.log('Sending phone verification code to:', userInfo.phone);
      await new Promise(resolve => setTimeout(resolve, 1000));
      setShowPhoneVerificationModal(true);
    } catch (err) {
      setError('Kod gönderilirken bir hata oluştu');
    } finally {
      setIsLoading(false);
    }
  };

  const handleVerifyPhoneCode = async () => {
    if (!phoneVerificationCode || phoneVerificationCode.length !== 6) {
      setError('Lütfen 6 haneli kodu girin');
      return;
    }

    setIsLoading(true);
    setError('');
    try {
      // Simulate API call
      console.log('Verifying phone code:', phoneVerificationCode);
      await new Promise(resolve => setTimeout(resolve, 1000));
      
      setIsPhoneVerified(true);
      setShowPhoneVerificationModal(false);
      setPhoneVerificationCode('');
      
      // Eğer telefon değiştirilmişse güncelle
      if (tempPhone) {
        setUserInfo(prev => ({ ...prev, phone: tempPhone }));
        setTempPhone('');
        setIsEditingPhone(false);
      }
    } catch (err) {
      setError('Kod doğrulanamadı');
    } finally {
      setIsLoading(false);
    }
  };

  const handleEditPhone = () => {
    setIsEditingPhone(true);
    setTempPhone(userInfo.phone);
  };

  const handleCancelEditPhone = () => {
    setIsEditingPhone(false);
    setTempPhone('');
  };

  const handleSavePhone = () => {
    if (tempPhone && tempPhone !== userInfo.phone) {
      setIsPhoneVerified(false);
      handleSendPhoneVerificationCode();
    }
  };

  return (
    <div className="md:h-screen pt-20 overflow-y-auto bg-base-1  md:pt-18 lg:pt-18 w-full">
      <div className="p-4 mx-auto">
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
          {/* Sol Taraf - Bilgi ve Şifre Değiştirme */}
          <div className="space-y-6">
            {/* Profil Kartı */}
            <div className="bg-base-2 rounded-3xl p-6">
              {/* Avatar ve İsim */}
              <div className="flex items-center gap-4 mb-6">
                <div className="relative">
                 <Image 
                    src="/assets/images/pp1.png" 
                    alt="Profile Avatar" 
                    width={64} 
                    height={64} 
                    className="rounded-full object-cover"
                  />
                  {/* Online Status */}
                  <div className="absolute bottom-0 right-0 w-4 h-4 bg-green-500 rounded-full border-2 border-base-2"></div>
                </div>
                <div>
                  <h2 className="text-white text-xl font-semibold">{userInfo.name}</h2>
                  <p className="text-gray-400 text-sm">{userInfo.username}</p>
                </div>
              </div>

              {/* Bilgi Bölümü */}
              <div className="space-y-4">
                <h3 className="text-white font-semibold text-lg mb-4">Bilgi</h3>
                
                <p className="text-gray-400 text-sm leading-relaxed">
                  Ad Soyad ve profil resimini ve kullanıcı adı değişikliği için deneme hesabı olduğunuzda Ad Soyad değişiklikleriniz sadece rapor kayıtlarında gözükmelidir. Kimliğiniz asla kullanılmaz yasaktır.
                </p>

                {/* Bilgi Alanları */}
                <div className="space-y-3 mt-6">
                  <div className="flex items-center justify-between py-3 border-b border-white/5">
                    <span className="text-gray-400 text-sm">Ad Soyad</span>
                    <span className="text-white text-sm font-medium">{userInfo.name}</span>
                  </div>

                  <div className="flex items-center justify-between py-3 border-b border-white/5">
                    <span className="text-gray-400 text-sm">Kullanıcı Adı</span>
                    <div className="flex items-center gap-2">
                      <span className="text-white text-sm font-medium">{userInfo.username}</span>
                      <button className="text-primary  flex items-center justify-center hover:text-primary/80 transition-colors">
                        <Iconify icon="mdi:content-copy" size={16} />
                      </button>
                    </div>
                  </div>

                  <div className="flex flex-col items-center justify-between py-3 border-b border-white/5">
                    <div className="w-full flex justify-between">
                    <span className="text-gray-400 text-sm">E-Posta</span>
                    <div className="flex items-center gap-2">
                      {isEditingEmail ? (
                        <>
                          <Input
                            type="email"
                            value={tempEmail}
                            onChange={(e) => setTempEmail(e.target.value)}
                            containerClassName="w-48"
                            className="text-sm"
                          />
                          <button 
                            onClick={handleSaveEmail}
                            className="text-green-400  flex items-center justify-center hover:text-green-300 transition-colors"
                          >
                            <Iconify icon="mdi:check" size={20} />
                          </button>
                          <button 
                            onClick={handleCancelEditEmail}
                            className="text-red-400  flex items-center justify-center hover:text-red-300 transition-colors"
                          >
                            <Iconify icon="mdi:close" size={20} />
                          </button>
                        </>
                      ) : (
                        <>
                          <span className="text-white text-sm font-medium">{userInfo.email}</span>
                          {isEmailVerified ? (
                            <div className="text-primary flex items-center justify-center ">
                              <Iconify icon="mdi:check-decagram" size={20} />
                            </div>
                          ) : (
                            <button 
                              onClick={handleEditEmail}
                              className="text-primary  flex items-center justify-center hover:text-primary/80 transition-colors"
                            >
                              <Iconify icon="mdi:pencil" size={16} />
                            </button>
                          )}
                        </>
                      )}
                      
                    </div>
                    </div>

                     {!isEmailVerified && !isEditingEmail && (
                    <div className="py-2 w-full">
                      <button
                        onClick={handleSendEmailVerificationCode}
                        disabled={isLoading}
                        className="text-primary w-full  text-end hover:text-primary/80 text-sm transition-colors disabled:opacity-50"
                      >
                        {isLoading ? 'Gönderiliyor...' : 'Doğrulama Kodu Gönder'}
                      </button>
                    </div>
                  )}

                  </div>

                 
                  <div className="flex flex-col items-center justify-between py-3 border-b border-white/5">
                    <div className="flex w-full justify-between">
                    <span className="text-gray-400 text-sm">Telefon Numarası</span>
                    <div className="flex items-center gap-2">
                      {isEditingPhone ? (
                        <>
                          <Input
                            type="tel"
                            value={tempPhone}
                            onChange={(e) => setTempPhone(e.target.value)}
                            containerClassName="w-48"
                            className="text-sm"
                          />
                          <button 
                            onClick={handleSavePhone}
                            className="text-green-400 hover:text-green-300 transition-colors"
                          >
                            <Iconify icon="mdi:check" size={20} />
                          </button>
                          <button 
                            onClick={handleCancelEditPhone}
                            className="text-red-400 flex items-center justify-center hover:text-red-300 transition-colors"
                          >
                            <Iconify icon="mdi:close" size={20} />
                          </button>
                        </>
                      ) : (
                        <>
                          <span className="text-white text-sm font-medium">{userInfo.phone}</span>
                          {isPhoneVerified ? (
                            <div className="text-primary flex items-center justify-center">
                              <Iconify icon="mdi:check-decagram" size={20} />
                            </div>
                          ) : (
                            <button 
                              onClick={handleEditPhone}
                              className="text-primary flex items-center justify-center hover:text-primary/80 transition-colors"
                            >
                              <Iconify icon="mdi:pencil" size={16} />
                            </button>
                          )}
                        </>
                      )}
                    </div>
                    </div>
                    {!isPhoneVerified && !isEditingPhone && (
                    <div className="py-2 w-full">
                      <button
                        onClick={handleSendPhoneVerificationCode}
                        disabled={isLoading}
                        className="text-primary w-full text-end hover:text-primary/80 text-sm transition-colors disabled:opacity-50"
                      >
                        {isLoading ? 'Gönderiliyor...' : 'Doğrulama Kodu Gönder'}
                      </button>
                    </div>
                  )}

                  </div>

                  

                  <div className="flex items-center justify-between py-3 border-b border-white/5">
                    <span className="text-gray-400 text-sm">Referans Veren</span>
                    <span className="text-white text-sm font-medium">{userInfo.referralCode}</span>
                  </div>

                  <div className="flex items-center justify-between py-3">
                    <span className="text-gray-400 text-sm">Katılım Tarihi</span>
                    <span className="text-white text-sm font-medium">{userInfo.joinDate}</span>
                  </div>
                </div>
              </div>
            </div>

            {/* Şifremi Değiştir */}
            <div className="bg-base-2 rounded-3xl p-6">
              <h3 className="text-white font-semibold text-lg mb-4">Şifremi Değiştir</h3>
              <p className="text-gray-400 text-sm mb-6">
                Değişmiş Hesap Güvenliği İçin
              </p>

              <div className="space-y-4">
                {/* Eski Şifre */}
                <Input
                  label="Eski Şifre"
                  type="password"
                  placeholder="Eski Şifre Giriniz"
                  value={passwordForm.currentPassword}
                  onChange={(e) => setPasswordForm({ ...passwordForm, currentPassword: e.target.value })}
                  containerClassName="w-full"
                />

                {/* Yeni Şifre */}
                <Input
                  label="Yeni Şifre"
                  type="password"
                  placeholder="Yeni Şifre"
                  value={passwordForm.newPassword}
                  onChange={(e) => setPasswordForm({ ...passwordForm, newPassword: e.target.value })}
                  containerClassName="w-full"
                />

                {/* Yeni Şifre Tekrar */}
                <Input
                  label="Yeni Şifre Tekrar"
                  type="password"
                  placeholder="Yeni Şifre Tekrar Giriniz"
                  value={passwordForm.confirmPassword}
                  onChange={(e) => setPasswordForm({ ...passwordForm, confirmPassword: e.target.value })}
                  containerClassName="w-full"
                />

                {/* Gönder Butonu */}
                <Button
                  variant="primary"
                  size="lg"
                  fullWidth
                  onClick={handlePasswordChange}
                  className="mt-2"
                >
                  Gönder
                </Button>
              </div>
            </div>
          </div>

          {/* Sağ Taraf - Ayarlar */}
          <div className="space-y-6">
            {/* Ayarlar */}
            <div className="bg-base-2 rounded-3xl p-6">
              <h3 className="text-white font-semibold text-lg mb-6">Ayarlar</h3>
              
              <div className="space-y-6">
                {/* Dil Seçimi */}
                <div>
                  <div className="flex items-center justify-between mb-2">
                    <label className="text-white text-sm font-medium">Dil</label>
                    <div className="flex items-center gap-2 bg-red-500/10 text-red-500 px-3 py-1 rounded-lg">
                      <Image 
                        src="/assets/icons/turkey-flag.svg" 
                        alt="TR" 
                        width={20} 
                        height={20}
                        className="rounded"
                      />
                      <span className="text-sm">{settings.language}</span>
                      <Iconify icon="mdi:chevron-down" size={16} />
                    </div>
                  </div>
                  <p className="text-gray-400 text-xs">Henüz Ayarların başlangıcı</p>
                </div>

                {/* Herkes Açık */}
                <div className="flex items-center justify-between py-3 border-b border-white/5">
                  <span className="text-white text-sm">Herkes Açık</span>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.everyone}
                    onChange={() => handleToggle('everyone')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* TI vs Göster */}
                <div className="flex items-center justify-between py-3 border-b border-white/5">
                  <div>
                    <p className="text-white text-sm">TI vs Göster</p>
                    <p className="text-gray-400 text-xs mt-1">
                      Herkese açık modu aktifken profildeki herkes görür.
                    </p>
                  </div>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.onlyFollowers}
                    onChange={() => handleToggle('onlyFollowers')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* Canlı İstatistikler */}
                <div className="flex items-center justify-between py-3 border-b border-white/5">
                  <span className="text-white text-sm">Canlı İstatistikler</span>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.liveShow}
                    onChange={() => handleToggle('liveShow')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* Mail Bildirimleri */}
                <div className="flex items-center justify-between py-3 border-b border-white/5">
                  <span className="text-white text-sm">Mail Bildirimleri</span>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.mailNotifications}
                    onChange={() => handleToggle('mailNotifications')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* SMS Bildirimleri */}
                <div className="flex items-center justify-between py-3 border-b border-white/5">
                  <span className="text-white text-sm">SMS Bildirimleri</span>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.smsNotifications}
                    onChange={() => handleToggle('smsNotifications')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* 2 Faktör kimlik doğrulama */}
                <div className="flex items-center justify-between py-3">
                  <span className="text-white text-sm">2 Faktör kimlik doğrulama</span>
                  <ToggleSwitch
                    defaultChecked={settings.notifications.twoFactorAuth}
                    onChange={() => handleToggle('twoFactorAuth')}
                    size="md"
                    variant="primary"
                  />
                </div>

                {/* Hesabı Sil */}
                <button
                  onClick={handleAccountDelete}
                  className="w-full mt-6 bg-red-500/10 hover:bg-red-500/20 text-red-500 px-4 py-3 rounded-xl font-medium transition-colors flex items-center justify-center gap-2"
                >
                  <Iconify icon="mdi:delete-outline" size={20} />
                  <span>Hesabı kaldı Geçici sil</span>
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
      
      {/* Email Verification Modal */}
      <Modal isOpen={showEmailVerificationModal} onClose={() => setShowEmailVerificationModal(false)}>
        <div className="space-y-4">
          <div>
            <h2 className="text-xl md:text-2xl font-semibold text-white text-start mb-2">
              E-posta Doğrulama
            </h2>
            <p className="text-sm text-gray-400">
              <span className="text-primary">{tempEmail || userInfo.email}</span> adresine gönderilen 6 haneli kodu girin.
            </p>
          </div>

          <div className="space-y-4">
            {error && (
              <div className="p-3 bg-red-500/10 border border-red-500/20 rounded-lg">
                <p className="text-sm text-red-400">{error}</p>
              </div>
            )}

            <Input
              label="Doğrulama Kodu"
              type="text"
              placeholder="123456"
              value={emailVerificationCode}
              onChange={(e) => {
                setEmailVerificationCode(e.target.value);
                setError('');
              }}
              maxLength={6}
              containerClassName="w-full"
            />

            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={handleVerifyEmailCode}
              disabled={isLoading}
            >
              {isLoading ? (
                <div className="flex items-center gap-2">
                  <div className="w-4 h-4 border-2 border-white/30 border-t-white rounded-full animate-spin" />
                  Doğrulanıyor...
                </div>
              ) : (
                'Tamam'
              )}
            </Button>

            <div className="text-center pt-2">
              <button
                onClick={handleSendEmailVerificationCode}
                disabled={isLoading}
                className="text-sm text-primary hover:text-primary/80 transition-colors disabled:opacity-50"
              >
                Kodu tekrar gönder
              </button>
            </div>
          </div>
        </div>
      </Modal>

      {/* Phone Verification Modal */}
      <Modal isOpen={showPhoneVerificationModal} onClose={() => setShowPhoneVerificationModal(false)}>
        <div className="space-y-4">
          <div>
            <h2 className="text-xl md:text-2xl font-semibold text-white text-start mb-2">
              Telefon Doğrulama
            </h2>
            <p className="text-sm text-gray-400">
              <span className="text-primary">{tempPhone || userInfo.phone}</span> numarasına gönderilen 6 haneli kodu girin.
            </p>
          </div>

          <div className="space-y-4">
            {error && (
              <div className="p-3 bg-red-500/10 border border-red-500/20 rounded-lg">
                <p className="text-sm text-red-400">{error}</p>
              </div>
            )}

            <Input
              label="Doğrulama Kodu"
              type="text"
              placeholder="123456"
              value={phoneVerificationCode}
              onChange={(e) => {
                setPhoneVerificationCode(e.target.value);
                setError('');
              }}
              maxLength={6}
              containerClassName="w-full"
            />

            <Button
              variant="primary"
              size="lg"
              fullWidth
              onClick={handleVerifyPhoneCode}
              disabled={isLoading}
            >
              {isLoading ? (
                <div className="flex items-center gap-2">
                  <div className="w-4 h-4 border-2 border-white/30 border-t-white rounded-full animate-spin" />
                  Doğrulanıyor...
                </div>
              ) : (
                'Tamam'
              )}
            </Button>

            <div className="text-center pt-2">
              <button
                onClick={handleSendPhoneVerificationCode}
                disabled={isLoading}
                className="text-sm text-primary hover:text-primary/80 transition-colors disabled:opacity-50"
              >
                Kodu tekrar gönder
              </button>
            </div>
          </div>
        </div>
      </Modal>
      
      <Footer />
    </div>
  );
}
