'use client'

import { useState } from "react"
import { usePathname } from "next/navigation"
import { Navbar, Sidebar, TabBar } from "@/components/layout"
import { MobileAppModal, MobileLiveChat } from "@/components/sections"


export default function DashboardLayout({ children }: { children: React.ReactNode }) {
  const [isMobileMenuOpen, setIsMobileMenuOpen] = useState(false)
  const [showMobileAppModal, setShowMobileAppModal] = useState(false)
  const [showMobileLiveChat, setShowMobileLiveChat] = useState(false)
  const pathname = usePathname()

  const toggleMobileMenu = () => {
    setIsMobileMenuOpen(!isMobileMenuOpen)
  }

  const closeMobileMenu = () => {
    setIsMobileMenuOpen(false)
  }

  const toggleMobileLiveChat = () => {
    setShowMobileLiveChat(!showMobileLiveChat)
  }

  // Eğer /home sayfasındaysa authenticated, değilse authenticated2
  const navbarVariant = pathname === '/home' ? 'authenticated' : 'authenticated2'

  return (
    <div className="flex flex-row h-full w-full">
        <Navbar 
          variant={navbarVariant} 
          onMenuToggle={toggleMobileMenu}
          onLiveChatToggle={toggleMobileLiveChat}
        />
        <div className="flex w-full pb-20 md:pb-0">
         <Sidebar 
           isMobileOpen={isMobileMenuOpen} 
           onClose={closeMobileMenu}
           onOpenMobileAppModal={() => setShowMobileAppModal(true)}
         />
          {children}
        </div>
        
        {/* Mobile TabBar */}
        <TabBar onMenuToggle={toggleMobileMenu} />
        
        {/* Mobile Live Chat */}
        <MobileLiveChat 
          isOpen={showMobileLiveChat}
          onClose={() => setShowMobileLiveChat(false)}
        />
        
        {/* Mobile App Modal */}
        <MobileAppModal 
          isOpen={showMobileAppModal} 
          onClose={() => setShowMobileAppModal(false)} 
        />
    </div>
  )
}
