'use client'

import { Footer } from "@/components/layout";
import { LiveSupport, DashboardCards, MobileDashboardCards, FeaturedTasksSection, FeaturedOffers } from "../_components";
import { useEffect, useRef, useState } from "react";
import { useRouter } from "next/navigation";
import { bankingOffers, techOffers, taskPartners, surveyPartners } from '@/data';
import { Button } from "@/components/ui/Button";
import { Icon } from "@/components/ui";
import { MobileAppModal } from "@/components/sections";


export default function HomePage() {
  const scrollContainerRef = useRef<HTMLDivElement>(null);
  const router = useRouter();
  const [showMobileAppModal, setShowMobileAppModal] = useState(false);

  useEffect(() => {
    const container = scrollContainerRef.current;
    if (!container) return;

    let scrollTimer: NodeJS.Timeout;

    const handleScroll = () => {
      // Add scrolling class
      container.classList.add('scrolling');
      
      // Clear existing timer
      clearTimeout(scrollTimer);
      
      // Remove scrolling class after scroll ends
      scrollTimer = setTimeout(() => {
        container.classList.remove('scrolling');
      }, 1000); // Hide after 1 second of no scrolling
    };

    container.addEventListener('scroll', handleScroll);

    return () => {
      container.removeEventListener('scroll', handleScroll);
      clearTimeout(scrollTimer);
    };
  }, []);

  return (
    <div className="flex-1 flex flex-row justify-between h-full overflow-hidden">

      {/* Sol taraf - Ana içerik (Scroll alanı) */}
      <div 
        ref={scrollContainerRef}
        className="w-full h-screen pt-20 lg:pt-0 overflow-y-auto scrollbar-hide scroll-smooth"
      >
        {/* Dashboard Cards - Sadece büyük ekranlarda göster */}
        <div className="hidden xl:block"><DashboardCards /></div>

        {/* Dashboard Cards - Sadece Diğer ekranlarda göster */}
        <div className="xl:hidden">
          <MobileDashboardCards />
        </div>


        {/* 1.Section Start */}
        <FeaturedTasksSection />
        {/* 1.Section End */}

        {/* CTA Button - Sadece Mobilde  göster */}
        <div className="md:hidden grid grid-cols-2 gap-3 py-2 px-4">
          <Button 
            onClick={() => setShowMobileAppModal(true)}
            leftIcon={<Icon size="md" name="fluent:headphones-sound-wave-24-filled" />} 
            fullWidth 
            variant="outline" 
            size="sm"
          >
            Dinle Kazan
          </Button>
          <Button 
            onClick={() => router.push('/micro-tasks')}
            leftIcon={<Icon size="md" name="task-2" />} 
            fullWidth 
            variant="outline" 
            size="sm"
          >
            Mikro Görevler
          </Button>
        </div>
        

         {/* 2.Section Start */}
         <FeaturedOffers 
           title="Öne Çıkan Teklifler"
           iconName="mdi:fire"
           offers={bankingOffers} 
           all_item
           enableModal
         />
         {/* 2.Section End */}
         
         {/* 3.Section Start */}
         <FeaturedOffers 
           title="Öne Çıkan Anketler"
           iconName="icon-park-outline:list"
           offers={techOffers} 
           cardVariant="default"
           all_item
           enableModal
         />
         {/* 3.Section End */}

         {/* 4.Section Start */}
           <FeaturedOffers 
           title="Görev Ortakları"
           iconName="mdi:crown"
           offers={taskPartners} 
           cardVariant="gradient2"
         />
         {/* 4.Section End */}

          {/* 5.Section Start */}
           <FeaturedOffers 
           title="Anket İş Ortakları"
           iconName="ep:data-line"
           offers={surveyPartners} 
           cardVariant="gradient2"
         />
         {/* 5.Section End */}
         
        <Footer />
       
        
      </div>

      {/* Sağ taraf - LiveSupport */}
      <div className="md:block hidden h-fit w-fit">
        <LiveSupport />
      </div>

      {/* Mobile App Modal */}
      <MobileAppModal 
        isOpen={showMobileAppModal} 
        onClose={() => setShowMobileAppModal(false)} 
      />
      
    </div>
  )
}
