'use client'

import { Iconify } from '@/components/ui'
import { cn } from '@/lib/utils'

export interface StatCardProps {
  /** İkon adı (Iconify formatında) */
  icon: string
  /** Ana değer (büyük font) */
  value?: string | number
  /** Alt başlık açıklaması */
  label?: string
  /** Boyut seçenekleri */
  size?: 'sm' | 'md' | 'lg'
  /** Renk seçenekleri */
  color?: 'default' | 'primary' | 'green'
  /** İkon rengi (Tailwind class) */
  iconColor?: string
  /** Ek CSS sınıfları */
  className?: string
}

export function StatCard({ 
  icon, 
  value, 
  label, 
  size = 'md',
  color = 'default',
  iconColor = 'text-white',
  className = '' 
}: StatCardProps) {
  
  // Size variants
  const sizeStyles = {
    sm: {
      container: 'p-1.5',
      iconWrapper: 'w-10 h-10',
      iconSize: 20,
      valueText: 'text-base',
      labelText: 'text-[11px]',
      blur: 'w-5 h-5'
    },
    md: {
      container: 'p-2',
      iconWrapper: 'w-12 h-12',
      iconSize: 24,
      valueText: 'text-lg',
      labelText: 'text-[12px]',
      blur: 'w-6 h-6'
    },
    lg: {
      container: 'p-3',
      iconWrapper: 'w-16 h-16',
      iconSize: 32,
      valueText: 'text-2xl',
      labelText: 'text-sm',
      blur: 'w-8 h-8'
    }
  }

  // Color variants
  const colorStyles = {
    default: {
      blur1: 'bg-white/60',
      blur2: 'bg-white/30'
    },
    primary: {
      blur1: 'bg-primary/60',
      blur2: 'bg-primary/30'
    },
    green: {
      blur1: 'bg-[#46B98B]/60',
      blur2: 'bg-[#46B98B]/30'
    }
  }

  const currentSize = sizeStyles[size]
  const currentColor = colorStyles[color]

  return (
    <div className={cn('rounded-xl flex flex-row space-x-2 items-center justify-center transition',
     
    
     currentSize.container, className)}>
      {/* İkon Container */}
      <div className={cn('p-[1px] w-fit h-fit bg-gradient-to-b from-[#6F629B] to-transparent rounded-[13px]',
      size === 'lg' && 'rounded-[16px]'

      )}>
        <div className={cn('flex overflow-hidden relative justify-center items-center bg-base-3 rounded-xl',
          size === 'lg' && 'rounded-2xl',
          currentSize.iconWrapper)}>
          {/* Değişken Renk - Alt */}
          <div className={cn('absolute rounded-full z-0 blur-md -bottom-3', currentSize.blur, currentColor.blur1)} />
          {/* Değişken Renk - Üst */}
          <div className={cn('absolute rounded-full z-0 blur-lg -top-6', currentSize.blur, currentColor.blur2)} />
          <div className="relative flex items-center justify-center">
            <Iconify className={iconColor} icon={icon} size={currentSize.iconSize} />
          </div>
        </div>
      </div>
      
      {/* Değer ve Label */}
      {label && value && (
        <div className="flex items-start w-46 flex-col">
          <p className={cn('line-clamp-1 font-semibold text-white', currentSize.valueText)}>{value}</p>
          <p className={cn('line-clamp-1 font-normal text-white/70', currentSize.labelText)}>{label}</p>
        </div>
      )}
    </div>
  )
}

export default StatCard
