import Image from "next/image";

interface Reward {
  id: number;
  title: string;
  subtitle: string;
  image: string;
  rank: string;
}

interface RewardsSectionProps {
  rewards: Reward[];
}

export default function RewardsSection({ rewards }: RewardsSectionProps) {
  return (
    <div className="bg-base-2 h-fit rounded-2xl md:rounded-3xl p-4 md:p-8 space-y-4 md:space-y-6">
      {/* Başlık */}
      <div>
        <h2 className="text-lg md:text-xl font-semibold text-white mb-1 md:mb-2">Ödüller</h2>
        
      </div>

      {/* Ödül Kartları */}
      <div className="space-y-3 md:space-y-4">
        {rewards.map((reward) => (
          <div
            key={reward.id}
            className="group relative bg-base-3 rounded-xl md:rounded-2xl overflow-hidden border border-base-3 hover:border-purple-500/50 transition-all duration-300"
          >
            <div className="flex items-center gap-2 md:gap-4 p-3 md:p-4">
              {/* Sol Numara */}
              <div className="text-2xl md:text-4xl font-bold text-white/20 w-8 md:w-12 text-center flex-shrink-0">
                {reward.id}
              </div>

              {/* Görsel */}
              <div className="relative w-16 h-16 md:w-24 md:h-24 rounded-lg md:rounded-xl overflow-hidden bg-gradient-to-br from-base-2 to-base-3 flex-shrink-0">
                <Image
                  src={reward.image}
                  alt={reward.title}
                  fill
                  className="object-cover group-hover:scale-105 transition-transform duration-300"
                />
              </div>

              {/* Bilgi */}
              <div className="flex-1 min-w-0">
                <h3 className="text-white font-semibold text-sm md:text-lg mb-0.5 md:mb-1 truncate">
                  {reward.title}
                </h3>
                <p className="text-gray-400 text-xs md:text-sm line-clamp-2">
                  {reward.subtitle}
                </p>
              </div>

              {/* Sağ Glow Effect */}
              <div className="absolute right-0 top-1/2 -translate-y-1/2 w-24 md:w-32 h-24 md:h-32 bg-gradient-to-l from-purple-500/10 to-transparent rounded-full blur-2xl group-hover:from-purple-500/30 transition-all" />
            </div>
          </div>
        ))}
      </div>
      <p className="text-xs w-full text-center md:text-sm text-gray-400">
          4.-5.-6.-7.-8.-9.-10. olan kişilerin her biri <span className="text-white font-semibold">1 adet çeyrek altın</span> alacaktır.
        </p>
    </div>
  );
}
