import { GetFromPatternOptions, EncryptStorageOptions, EncryptStorageInterface, RemoveFromPatternOptions } from './types';
export declare class EncryptStorage implements EncryptStorageInterface {
    #private;
    readonly storage: Storage | null;
    /**
     * EncryptStorage provides a wrapper implementation of `localStorage` and `sessionStorage` for a better security solution in browser data store
     *
     * @param {string} secretKey - A secret to encrypt data must be contain min of 10 characters
     * @param {EncrytStorageOptions} options - A optional settings to set encryptData or select `sessionStorage` to browser storage
     */
    constructor(secretKey: string, options?: EncryptStorageOptions);
    get length(): number;
    setItem(key: string, value: any, doNotEncrypt?: boolean): void;
    setMultipleItems(param: [string, any][], doNotEncrypt?: boolean): void;
    getItem<T = any>(key: string, doNotDecrypt?: boolean): T | undefined;
    getMultipleItems(keys: string[], doNotDecrypt?: boolean): Record<string, any>;
    removeItem(key: string): void;
    removeMultipleItems(keys: string[]): void;
    removeItemFromPattern(pattern: string, options?: RemoveFromPatternOptions): void;
    getItemFromPattern(pattern: string, options?: GetFromPatternOptions): Record<string, any> | undefined;
    clear(): void;
    key(index: number): string | null;
    /**
     * @deprecated This function will be `deprecated` in ^3.x versions in favor of the encryptValue function and will be removed in the future.
     */
    encryptString(str: string): string;
    /**
     * @deprecated This function will be `deprecated` in ^3.x versions in favor of the decryptValue function and will be removed in the future.
     */
    decryptString(str: string): string;
    encryptValue(value: any): string;
    decryptValue<T = any>(value: string): T;
    hash(value: string): string;
    md5Hash(value: string): string;
}
export default EncryptStorage;
