import { AbstractExpressionParser } from './AbstractExpressionParser.js';
import { generateUndefineValue } from '../entity/Value.js';
import { ModelEntry } from '../entity/ModelEntry.js';
export class ModelParser extends AbstractExpressionParser {
    parseObjectProperty(node) {
        const { value: { prop, event } } = this.getValue(node.value);
        const entry = new ModelEntry(prop, event);
        this.root.defaultModelPropName = prop;
        this.setScopeValue(entry.prop, node, generateUndefineValue.next().value, { global: true });
        this.parseEntryComment(entry, node);
        this.emit(entry);
    }
}
//# sourceMappingURL=ModelParser.js.map