import { ComputedParser } from './ComputedParser.js';
import { ComputedEntry } from '../entity/ComputedEntry.js';
import { Syntax, Type } from '../lib/Enum.js';
export class ClassComponentComputedParser extends ComputedParser {
    parseNode(node, type = Type.unknown, dependencies = []) {
        const name = node.key.type === Syntax.Identifier
            ? node.key.name
            : this.getValue(node.key).value;
        const entry = new ComputedEntry({ name, type, dependencies });
        this.parseEntry(entry, node, node.body || node);
    }
}
//# sourceMappingURL=ClassComponentComputedParser.js.map