export class MissingLoaderError extends Error {
}
export class Loader {
    constructor(options) {
        this.options = options;
    }
    static extend(name, loader) {
        return { name, loader };
    }
    static get(name, options) {
        const item = options.definitions.find((loader) => loader.name === name);
        if (!item) {
            throw new MissingLoaderError(`Missing loader for ${name}`);
        }
        return item.loader;
    }
    get source() {
        return this.options.source;
    }
    emitTemplate(data) {
        this.options.source.template = data;
    }
    emitScript(data) {
        this.options.source.script = data;
    }
    emitErrors(errors) {
        this.options.source.errors.push(...errors);
    }
    pipe(name, data) {
        const LoaderClass = Loader.get(name, this.options);
        return new LoaderClass(this.options).load(data);
    }
}
//# sourceMappingURL=Loader.js.map