import { dirname } from 'node:path';
import { Syntax } from './Enum.js';
export class Import {
    constructor(fs, specifier, node, source, createRegister, resolver = {}) {
        this.fs = fs;
        this.specifier = specifier;
        this.source = source;
        this.resolver = resolver;
        this.createRegister = createRegister;
        this.importDeclaration = node;
        if (!this.importDeclaration.exposedScope) {
            this.importDeclaration.exposedScope = {};
        }
    }
    loadPackage() {
        if (this.importDeclaration.$loaded) {
            return;
        }
        const resolver = this.source.filename
            ? { ...this.resolver, basedir: dirname(this.source.filename) }
            : this.resolver;
        try {
            const file = this.fs.loadFile(this.importDeclaration.source.value, resolver);
            if (file.script) {
                const register = this.createRegister(file.script, file);
                register.parseAst(file.script.ast.program);
                this.importDeclaration.exposedScope = { ...register.exposedScope };
            }
        }
        finally {
            this.importDeclaration.$loaded = true;
        }
    }
    loadSpecifierNode() {
        if (this.specifier.scopeEntry || this.specifier.ns) {
            return;
        }
        switch (this.specifier.type) {
            case Syntax.ImportDefaultSpecifier:
                this.specifier.scopeEntry = this.importDeclaration.exposedScope.default;
                break;
            case Syntax.ImportNamespaceSpecifier: {
                this.specifier.ns = {
                    $ns: Symbol('ns'),
                    scope: {
                        ...this.importDeclaration.exposedScope,
                    },
                };
                break;
            }
            default:
                if ('imported' in this.specifier) {
                    const id = 'name' in this.specifier.imported
                        ? this.specifier.imported.name
                        : this.specifier.imported.value;
                    if (id in this.importDeclaration.exposedScope) {
                        this.specifier.scopeEntry = this.importDeclaration.exposedScope[id];
                    }
                }
                break;
        }
    }
    load() {
        this.loadPackage();
        this.loadSpecifierNode();
    }
}
//# sourceMappingURL=Import.js.map