import { Type } from '../lib/Enum.js';
import { AbstractCategorizeEntry } from './AbstractCategorizeEntry.js';
import { toKebabCase } from '../utils/string.js';
export class PropEntry extends AbstractCategorizeEntry {
    constructor({ name, type = Type.unknown, defaultValue, required = false, describeModel = false }) {
        super('prop');
        this.name = toKebabCase(name);
        this.type = type;
        this.default = defaultValue;
        this.required = required;
        this.describeModel = describeModel;
    }
}
//# sourceMappingURL=PropEntry.js.map