import { toKebabCase } from '../utils/string.js';
import { Visibility } from '../lib/Enum.js';
import { AbstractDecorativeEntry } from './AbstractDecorativeEntry.js';
export class ModelEntry extends AbstractDecorativeEntry {
    /**
     * By default:
     * - Vue 3: v-model on a component uses `modelValue` as the prop and `update:modelValue` as the event
     * - Vue 2: v-model on a component uses `value` as the prop and `input` as the event
     */
    constructor(propNameInCamelCase = 'value', event = 'input') {
        super('model');
        this.visibility = Visibility.public;
        this.name = propNameInCamelCase;
        this.prop = toKebabCase(propNameInCamelCase, [':']);
        this.event = event;
    }
}
//# sourceMappingURL=ModelEntry.js.map