import * as vue from '@vue/language-core';
import type * as ts from 'typescript/lib/tsserverlibrary';
export { getProgram, decorateLanguageServiceHost, searchExternalFiles } from '@volar/typescript';
export declare function createLanguageService(host: vue.TypeScriptLanguageHost, vueCompilerOptions: Partial<vue.VueCompilerOptions>, ts: typeof import('typescript/lib/tsserverlibrary'), sys: ts.System): {
    __internal__: {
        context: vue.LanguageContext;
    };
    cleanupSemanticCache(): void;
    getSyntacticDiagnostics(fileName: string): ts.DiagnosticWithLocation[];
    getSemanticDiagnostics(fileName: string): ts.Diagnostic[];
    getSuggestionDiagnostics(fileName: string): ts.DiagnosticWithLocation[];
    getCompilerOptionsDiagnostics(): ts.Diagnostic[];
    getSyntacticClassifications(fileName: string, span: ts.TextSpan): ts.ClassifiedSpan[];
    getSyntacticClassifications(fileName: string, span: ts.TextSpan, format: ts.SemanticClassificationFormat): ts.ClassifiedSpan[] | ts.ClassifiedSpan2020[];
    getSemanticClassifications(fileName: string, span: ts.TextSpan): ts.ClassifiedSpan[];
    getSemanticClassifications(fileName: string, span: ts.TextSpan, format: ts.SemanticClassificationFormat): ts.ClassifiedSpan[] | ts.ClassifiedSpan2020[];
    getEncodedSyntacticClassifications(fileName: string, span: ts.TextSpan): ts.Classifications;
    getEncodedSemanticClassifications(fileName: string, span: ts.TextSpan, format?: ts.SemanticClassificationFormat | undefined): ts.Classifications;
    getCompletionsAtPosition(fileName: string, position: number, options: ts.GetCompletionsAtPositionOptions | undefined, formattingSettings?: ts.FormatCodeSettings | undefined): ts.WithMetadata<ts.CompletionInfo> | undefined;
    getCompletionEntryDetails(fileName: string, position: number, entryName: string, formatOptions: ts.FormatCodeSettings | ts.FormatCodeOptions | undefined, source: string | undefined, preferences: ts.UserPreferences | undefined, data: ts.CompletionEntryData | undefined): ts.CompletionEntryDetails | undefined;
    getCompletionEntrySymbol(fileName: string, position: number, name: string, source: string | undefined): ts.Symbol | undefined;
    getQuickInfoAtPosition(fileName: string, position: number): ts.QuickInfo | undefined;
    getNameOrDottedNameSpan(fileName: string, startPos: number, endPos: number): ts.TextSpan | undefined;
    getBreakpointStatementAtPosition(fileName: string, position: number): ts.TextSpan | undefined;
    getSignatureHelpItems(fileName: string, position: number, options: ts.SignatureHelpItemsOptions | undefined): ts.SignatureHelpItems | undefined;
    getRenameInfo(fileName: string, position: number, preferences: ts.UserPreferences): ts.RenameInfo;
    getRenameInfo(fileName: string, position: number, options?: ts.RenameInfoOptions | undefined): ts.RenameInfo;
    findRenameLocations(fileName: string, position: number, findInStrings: boolean, findInComments: boolean, preferences: ts.UserPreferences): readonly ts.RenameLocation[] | undefined;
    findRenameLocations(fileName: string, position: number, findInStrings: boolean, findInComments: boolean, providePrefixAndSuffixTextForRename?: boolean | undefined): readonly ts.RenameLocation[] | undefined;
    getSmartSelectionRange(fileName: string, position: number): ts.SelectionRange;
    getDefinitionAtPosition(fileName: string, position: number): readonly ts.DefinitionInfo[] | undefined;
    getDefinitionAndBoundSpan(fileName: string, position: number): ts.DefinitionInfoAndBoundSpan | undefined;
    getTypeDefinitionAtPosition(fileName: string, position: number): readonly ts.DefinitionInfo[] | undefined;
    getImplementationAtPosition(fileName: string, position: number): readonly ts.ImplementationLocation[] | undefined;
    getReferencesAtPosition(fileName: string, position: number): ts.ReferenceEntry[] | undefined;
    findReferences(fileName: string, position: number): ts.ReferencedSymbol[] | undefined;
    getDocumentHighlights(fileName: string, position: number, filesToSearch: string[]): ts.DocumentHighlights[] | undefined;
    getFileReferences(fileName: string): ts.ReferenceEntry[];
    getNavigateToItems(searchValue: string, maxResultCount?: number | undefined, fileName?: string | undefined, excludeDtsFiles?: boolean | undefined): ts.NavigateToItem[];
    getNavigationBarItems(fileName: string): ts.NavigationBarItem[];
    getNavigationTree(fileName: string): ts.NavigationTree;
    prepareCallHierarchy(fileName: string, position: number): ts.CallHierarchyItem | ts.CallHierarchyItem[] | undefined;
    provideCallHierarchyIncomingCalls(fileName: string, position: number): ts.CallHierarchyIncomingCall[];
    provideCallHierarchyOutgoingCalls(fileName: string, position: number): ts.CallHierarchyOutgoingCall[];
    provideInlayHints(fileName: string, span: ts.TextSpan, preferences: ts.UserPreferences | undefined): ts.InlayHint[];
    getOutliningSpans(fileName: string): ts.OutliningSpan[];
    getTodoComments(fileName: string, descriptors: ts.TodoCommentDescriptor[]): ts.TodoComment[];
    getBraceMatchingAtPosition(fileName: string, position: number): ts.TextSpan[];
    getIndentationAtPosition(fileName: string, position: number, options: ts.EditorSettings | ts.EditorOptions): number;
    getFormattingEditsForRange(fileName: string, start: number, end: number, options: ts.FormatCodeSettings | ts.FormatCodeOptions): ts.TextChange[];
    getFormattingEditsForDocument(fileName: string, options: ts.FormatCodeSettings | ts.FormatCodeOptions): ts.TextChange[];
    getFormattingEditsAfterKeystroke(fileName: string, position: number, key: string, options: ts.FormatCodeSettings | ts.FormatCodeOptions): ts.TextChange[];
    getDocCommentTemplateAtPosition(fileName: string, position: number, options?: ts.DocCommentTemplateOptions | undefined, formatOptions?: ts.FormatCodeSettings | undefined): ts.TextInsertion | undefined;
    isValidBraceCompletionAtPosition(fileName: string, position: number, openingBrace: number): boolean;
    getJsxClosingTagAtPosition(fileName: string, position: number): ts.JsxClosingTagInfo | undefined;
    getLinkedEditingRangeAtPosition(fileName: string, position: number): ts.LinkedEditingInfo | undefined;
    getSpanOfEnclosingComment(fileName: string, position: number, onlyMultiLine: boolean): ts.TextSpan | undefined;
    toLineColumnOffset?(fileName: string, position: number): ts.LineAndCharacter;
    getCodeFixesAtPosition(fileName: string, start: number, end: number, errorCodes: readonly number[], formatOptions: ts.FormatCodeSettings, preferences: ts.UserPreferences): readonly ts.CodeFixAction[];
    getCombinedCodeFix(scope: ts.CombinedCodeFixScope, fixId: {}, formatOptions: ts.FormatCodeSettings, preferences: ts.UserPreferences): ts.CombinedCodeActions;
    applyCodeActionCommand(action: ts.InstallPackageAction, formatSettings?: ts.FormatCodeSettings | undefined): Promise<ts.ApplyCodeActionCommandResult>;
    applyCodeActionCommand(action: ts.InstallPackageAction[], formatSettings?: ts.FormatCodeSettings | undefined): Promise<ts.ApplyCodeActionCommandResult[]>;
    applyCodeActionCommand(action: ts.InstallPackageAction | ts.InstallPackageAction[], formatSettings?: ts.FormatCodeSettings | undefined): Promise<ts.ApplyCodeActionCommandResult | ts.ApplyCodeActionCommandResult[]>;
    applyCodeActionCommand(fileName: string, action: ts.InstallPackageAction): Promise<ts.ApplyCodeActionCommandResult>;
    applyCodeActionCommand(fileName: string, action: ts.InstallPackageAction[]): Promise<ts.ApplyCodeActionCommandResult[]>;
    applyCodeActionCommand(fileName: string, action: ts.InstallPackageAction | ts.InstallPackageAction[]): Promise<ts.ApplyCodeActionCommandResult | ts.ApplyCodeActionCommandResult[]>;
    getApplicableRefactors(fileName: string, positionOrRange: number | ts.TextRange, preferences: ts.UserPreferences | undefined, triggerReason?: ts.RefactorTriggerReason | undefined, kind?: string | undefined, includeInteractiveActions?: boolean | undefined): ts.ApplicableRefactorInfo[];
    getEditsForRefactor(fileName: string, formatOptions: ts.FormatCodeSettings, positionOrRange: number | ts.TextRange, refactorName: string, actionName: string, preferences: ts.UserPreferences | undefined, interactiveRefactorArguments?: ts.InteractiveRefactorArguments | undefined): ts.RefactorEditInfo | undefined;
    getMoveToRefactoringFileSuggestions(fileName: string, positionOrRange: number | ts.TextRange, preferences: ts.UserPreferences | undefined, triggerReason?: ts.RefactorTriggerReason | undefined, kind?: string | undefined): {
        newFileName: string;
        files: string[];
    };
    organizeImports(args: ts.OrganizeImportsArgs, formatOptions: ts.FormatCodeSettings, preferences: ts.UserPreferences | undefined): readonly ts.FileTextChanges[];
    getEditsForFileRename(oldFilePath: string, newFilePath: string, formatOptions: ts.FormatCodeSettings, preferences: ts.UserPreferences | undefined): readonly ts.FileTextChanges[];
    getEmitOutput(fileName: string, emitOnlyDtsFiles?: boolean | undefined, forceDtsEmit?: boolean | undefined): ts.EmitOutput;
    getProgram(): ts.Program | undefined;
    toggleLineComment(fileName: string, textRange: ts.TextRange): ts.TextChange[];
    toggleMultilineComment(fileName: string, textRange: ts.TextRange): ts.TextChange[];
    commentSelection(fileName: string, textRange: ts.TextRange): ts.TextChange[];
    uncommentSelection(fileName: string, textRange: ts.TextRange): ts.TextChange[];
    getSupportedCodeFixes(fileName?: string | undefined): readonly string[];
    dispose(): void;
};
export declare function decorateLanguageService(virtualFiles: vue.VirtualFiles, ls: ts.LanguageService, isTsPlugin: boolean): void;
//# sourceMappingURL=index.d.ts.map