import { Component } from 'vue';
import * as birpc from 'birpc';
import { BirpcGroupReturn } from 'birpc';
import { WebSocketServer } from 'vite';
import { ViteHotContext } from 'vite-hot-client';

declare enum DevToolsHooks {
    APP_INIT = "app:init",
    APP_UNMOUNT = "app:unmount",
    COMPONENT_UPDATED = "component:updated",
    COMPONENT_ADDED = "component:added",
    COMPONENT_REMOVED = "component:removed",
    COMPONENT_EMIT = "component:emit",
    PERFORMANCE_START = "perf:start",
    PERFORMANCE_END = "perf:end",
    ADD_ROUTE = "router:add-route",
    REMOVE_ROUTE = "router:remove-route",
    RENDER_TRACKED = "render:tracked",
    RENDER_TRIGGERED = "render:triggered"
}
declare function createDevToolsHook(): any;
declare function collectDevToolsHookBuffer(): {
    hookBuffer: [string, Record<string, unknown>][];
    collect: (type: DevToolsHooks, args: Record<string, unknown>) => void;
};

declare function createDevToolsContainer(App: Component): void;

declare function createRPCServer<T extends {}>(server: WebSocketServer, functions: Record<string, unknown>): BirpcGroupReturn<T>;
declare function createRPCClient<T extends {}>(ctx: ViteHotContext, functions: Partial<T>): birpc.BirpcReturn<T, {}>;

declare const PLUGIN_NAME = "vite-plugin-vue-devtools";

declare function getComponentTypeName(options: any): any;
declare function getComponentFileName(options: any): any;
/**
 * Get the appropriate display name for an instance.
 *
 * @param {Vue} instance
 * @return {String}
 */
declare function getInstanceName(instance: any): any;

export { DevToolsHooks, PLUGIN_NAME, collectDevToolsHookBuffer, createDevToolsContainer, createDevToolsHook, createRPCClient, createRPCServer, getComponentFileName, getComponentTypeName, getInstanceName };
