import * as magic_string from 'magic-string';

interface AnalyzeOptions {
    /**
     * @default true
     */
    rerenderTrace: boolean;
}
declare const analyzeOptionsDefault: {
    rerenderTrace: boolean;
};
type DeepRequired<T> = {
    [P in keyof T]-?: T[P] extends object ? DeepRequired<T[P]> : Required<T[P]>;
};
declare function analyzeCode(code: string, filename: string, options: AnalyzeOptions): string | {
    code: string;
    readonly map: magic_string.SourceMap;
};

export { type AnalyzeOptions, type DeepRequired, analyzeCode, analyzeOptionsDefault };
