'use strict';

function splitSVGDefs(content) {
  let defs = "";
  const index = content.indexOf("<defs");
  while (index >= 0) {
    const start = content.indexOf(">", index);
    const end = content.indexOf("</defs");
    if (start === -1 || end === -1) {
      break;
    }
    const endEnd = content.indexOf(">", end);
    if (endEnd === -1) {
      break;
    }
    defs += content.slice(start + 1, end).trim();
    content = content.slice(0, index).trim() + content.slice(endEnd + 1);
  }
  return {
    defs,
    content
  };
}
function mergeDefsAndContent(defs, content) {
  return "<defs>" + defs + "</defs>" + content;
}
function wrapSVGContent(body, start, end) {
  const { defs, content } = splitSVGDefs(body);
  return (defs ? "<defs>" + defs + "</defs>" : "") + start + content + end;
}

exports.mergeDefsAndContent = mergeDefsAndContent;
exports.splitSVGDefs = splitSVGDefs;
exports.wrapSVGContent = wrapSVGContent;
