import { IconifyIcon } from '@iconify/types';
import { IconCSSCommonCodeOptions, IconCSSItemOptions } from './types.js';

/**
 * Generates common CSS rules for multiple icons
 */
declare function getCommonCSSRules(options: IconCSSCommonCodeOptions): Record<string, string>;
/**
 * Generate CSS rules for one icon
 *
 * This function excludes common rules
 */
declare function generateItemCSSRules(icon: Required<IconifyIcon>, options: IconCSSItemOptions): Record<string, string>;

export { generateItemCSSRules, getCommonCSSRules };
