<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $super = Role::create(['name' => 'super-admin', 'title' => 'Sistem Yönetici']);
        $super->givePermissionTo(Permission::pluck('name')); // Permission of guard_name = admin

        $admin = Role::create(['name' => 'member', 'title' => 'Kullanıcı']);
        $admin->givePermissionTo(Permission::whereNot('name', 'like', '%users%')->pluck('name')); // Permission of guard_name = admin
    }
}
