<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incoming_demands', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->index();
            $table->integer('demand_user_id')->index();
            $table->integer('demand_id')->index();
            $table->integer('ad_id')->index();
            $table->decimal('offer')->nullable();
            $table->text('message')->nullable();
            $table->string('ip_address');
            $table->text('device');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incoming_demands');
    }
};
